/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.gson;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.PojoUtils;

public class GsonJsonObjectInput
implements ObjectInput {
    private final BufferedReader reader;
    private Gson gson;

    public GsonJsonObjectInput(InputStream in) {
        this(new InputStreamReader(in));
    }

    public GsonJsonObjectInput(Reader reader) {
        this.reader = new BufferedReader(reader);
        this.gson = new Gson();
    }

    @Override
    public boolean readBool() throws IOException {
        return this.read(Boolean.TYPE);
    }

    @Override
    public byte readByte() throws IOException {
        return this.read(Byte.TYPE);
    }

    @Override
    public short readShort() throws IOException {
        return this.read(Short.TYPE);
    }

    @Override
    public int readInt() throws IOException {
        return this.read(Integer.TYPE);
    }

    @Override
    public long readLong() throws IOException {
        return this.read(Long.TYPE);
    }

    @Override
    public float readFloat() throws IOException {
        return this.read(Float.TYPE).floatValue();
    }

    @Override
    public double readDouble() throws IOException {
        return this.read(Double.TYPE);
    }

    @Override
    public String readUTF() throws IOException {
        return this.read(String.class);
    }

    @Override
    public byte[] readBytes() throws IOException {
        return this.readLine().getBytes();
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        String json = this.readLine();
        return this.gson.fromJson(json, String.class);
    }

    @Override
    public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
        return this.read(cls);
    }

    @Override
    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        T value = this.readObject(cls);
        return (T)PojoUtils.realize(value, cls, type);
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null || line.trim().length() == 0) {
            throw new EOFException();
        }
        return line;
    }

    private <T> T read(Class<T> cls) throws IOException {
        String json = this.readLine();
        return (T)this.gson.fromJson(json, cls);
    }
}

