/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcStatus;

@Activate(group={"consumer"}, value={"actives"})
public class ActiveLimitFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String methodName = invocation.getMethodName();
        int max = invoker.getUrl().getMethodParameter(methodName, "actives", 0);
        RpcStatus count = RpcStatus.getStatus(invoker.getUrl(), invocation.getMethodName());
        if (!RpcStatus.beginCount(url, methodName, max)) {
            long timeout = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "timeout", 0);
            long start = System.currentTimeMillis();
            long remain = timeout;
            RpcStatus rpcStatus = count;
            synchronized (rpcStatus) {
                while (!RpcStatus.beginCount(url, methodName, max)) {
                    long elapsed;
                    try {
                        count.wait(remain);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((remain = timeout - (elapsed = System.currentTimeMillis() - start)) > 0L) continue;
                    throw new RpcException("Waiting concurrent invoke timeout in client-side for service:  " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", elapsed: " + elapsed + ", timeout: " + timeout + ". concurrent invokes: " + count.getActive() + ". max concurrent invoke limit: " + max);
                }
            }
        }
        boolean isSuccess = true;
        long begin = System.currentTimeMillis();
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (RuntimeException t) {
            isSuccess = false;
            throw t;
        }
        finally {
            RpcStatus.endCount(url, methodName, System.currentTimeMillis() - begin, isSuccess);
            if (max > 0) {
                RpcStatus rpcStatus = count;
                synchronized (rpcStatus) {
                    count.notifyAll();
                }
            }
        }
    }
}

