/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.RpcResult;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.Merger;
import org.apache.dubbo.rpc.cluster.merger.MergerFactory;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public class MergeableClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger log = LoggerFactory.getLogger(MergeableClusterInvoker.class);
    private ExecutorService executor = Executors.newCachedThreadPool(new NamedThreadFactory("mergeable-cluster-executor", true));

    public MergeableClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    protected Result doInvoke(final Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        Class<?> returnType;
        this.checkInvokers(invokers, invocation);
        String merger = this.getUrl().getMethodParameter(invocation.getMethodName(), "merger");
        if (ConfigUtils.isEmpty(merger)) {
            for (Invoker<T> invoker : invokers) {
                if (!invoker.isAvailable()) continue;
                try {
                    return invoker.invoke(invocation);
                }
                catch (RpcException e) {
                    if (e.isNoInvokerAvailableAfterFilter()) {
                        log.debug("No available provider for service" + this.directory.getUrl().getServiceKey() + " on group " + invoker.getUrl().getParameter("group") + ", will continue to try another group.");
                        continue;
                    }
                    throw e;
                }
            }
            return invokers.iterator().next().invoke(invocation);
        }
        try {
            returnType = this.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes()).getReturnType();
        }
        catch (NoSuchMethodException e) {
            returnType = null;
        }
        HashMap<String, Future<Result>> results = new HashMap<String, Future<Result>>();
        for (final Invoker<T> invoker : invokers) {
            Future<Result> future = this.executor.submit(new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    return invoker.invoke(new RpcInvocation(invocation, invoker));
                }
            });
            results.put(invoker.getUrl().getServiceKey(), future);
        }
        Object result = null;
        ArrayList<Result> resultList = new ArrayList<Result>(results.size());
        int timeout = this.getUrl().getMethodParameter(invocation.getMethodName(), "timeout", 1000);
        for (Map.Entry entry : results.entrySet()) {
            Future future = (Future)entry.getValue();
            try {
                Result r = (Result)future.get(timeout, TimeUnit.MILLISECONDS);
                if (r.hasException()) {
                    log.error("Invoke " + this.getGroupDescFromServiceKey((String)entry.getKey()) + " failed: " + r.getException().getMessage(), r.getException());
                    continue;
                }
                resultList.add(r);
            }
            catch (Exception e) {
                throw new RpcException("Failed to invoke service " + (String)entry.getKey() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (resultList.isEmpty()) {
            return new RpcResult((Object)null);
        }
        if (resultList.size() == 1) {
            return (Result)resultList.iterator().next();
        }
        if (returnType == Void.TYPE) {
            return new RpcResult((Object)null);
        }
        if (merger.startsWith(".")) {
            Method method;
            merger = merger.substring(1);
            try {
                method = returnType.getMethod(merger, returnType);
            }
            catch (NoSuchMethodException e) {
                throw new RpcException("Can not merge result because missing method [ " + merger + " ] in class [ " + returnType.getClass().getName() + " ]");
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            result = ((Result)resultList.remove(0)).getValue();
            try {
                if (method.getReturnType() != Void.TYPE && method.getReturnType().isAssignableFrom(result.getClass())) {
                    for (Result r : resultList) {
                        result = method.invoke(result, r.getValue());
                    }
                }
                for (Result r : resultList) {
                    method.invoke(result, r.getValue());
                }
            }
            catch (Exception e) {
                throw new RpcException("Can not merge result: " + e.getMessage(), (Throwable)e);
            }
        } else {
            Merger resultMerger = ConfigUtils.isDefault(merger) ? MergerFactory.getMerger(returnType) : ExtensionLoader.getExtensionLoader(Merger.class).getExtension(merger);
            if (resultMerger != null) {
                ArrayList<Object> rets = new ArrayList<Object>(resultList.size());
                for (Result r : resultList) {
                    rets.add(r.getValue());
                }
                result = resultMerger.merge(rets.toArray((Object[])Array.newInstance(returnType, 0)));
            } else {
                throw new RpcException("There is no merger to merge result.");
            }
        }
        return new RpcResult(result);
    }

    @Override
    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    @Override
    public URL getUrl() {
        return this.directory.getUrl();
    }

    @Override
    public boolean isAvailable() {
        return this.directory.isAvailable();
    }

    @Override
    public void destroy() {
        this.directory.destroy();
    }

    private String getGroupDescFromServiceKey(String key) {
        int index = key.indexOf("/");
        if (index > 0) {
            return "group [ " + key.substring(0, index) + " ]";
        }
        return key;
    }
}

