/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;

public class ClusterUtils {
    private ClusterUtils() {
    }

    public static URL mergeUrl(URL remoteUrl, Map<String, String> localMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, String> remoteMap = remoteUrl.getParameters();
        if (remoteMap != null && remoteMap.size() > 0) {
            map.putAll(remoteMap);
            map.remove("threadname");
            map.remove("default.threadname");
            map.remove("threadpool");
            map.remove("default.threadpool");
            map.remove("corethreads");
            map.remove("default.corethreads");
            map.remove("threads");
            map.remove("default.threads");
            map.remove("queues");
            map.remove("default.queues");
            map.remove("alive");
            map.remove("default.alive");
            map.remove("transporter");
            map.remove("default.transporter");
            map.remove("async");
            map.remove("default.async");
            HashSet<String> methodAsyncKey = new HashSet<String>();
            for (String key : map.keySet()) {
                if (key == null || !key.endsWith(".async")) continue;
                methodAsyncKey.add(key);
            }
            for (String needRemove : methodAsyncKey) {
                map.remove(needRemove);
            }
        }
        if (localMap != null && localMap.size() > 0) {
            String remoteGroup = (String)map.get("group");
            String remoteRelease = (String)map.get("release");
            map.putAll(localMap);
            map.put("group", remoteGroup);
            map.remove("release");
            if (StringUtils.isNotEmpty(remoteRelease)) {
                map.put("release", remoteRelease);
            }
        }
        if (remoteMap != null && remoteMap.size() > 0) {
            String remoteTimestamp;
            String methods;
            String version;
            String dubbo = remoteMap.get("dubbo");
            if (dubbo != null && dubbo.length() > 0) {
                map.put("dubbo", dubbo);
            }
            if ((version = remoteMap.get("version")) != null && version.length() > 0) {
                map.put("version", version);
            }
            if ((methods = remoteMap.get("methods")) != null && methods.length() > 0) {
                map.put("methods", methods);
            }
            if ((remoteTimestamp = remoteMap.get("timestamp")) != null && remoteTimestamp.length() > 0) {
                map.put("remote.timestamp", remoteMap.get("timestamp"));
            }
            map.put("remote.application", remoteMap.get("application"));
            String remoteFilter = remoteMap.get("reference.filter");
            String localFilter = localMap.get("reference.filter");
            if (remoteFilter != null && remoteFilter.length() > 0 && localFilter != null && localFilter.length() > 0) {
                localMap.put("reference.filter", remoteFilter + "," + localFilter);
            }
            String remoteListener = remoteMap.get("invoker.listener");
            String localListener = localMap.get("invoker.listener");
            if (remoteListener != null && remoteListener.length() > 0 && localListener != null && localListener.length() > 0) {
                localMap.put("invoker.listener", remoteListener + "," + localListener);
            }
        }
        return remoteUrl.clearParameters().addParameters(map);
    }
}

