/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.tag;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigChangeEvent;
import org.apache.dubbo.configcenter.ConfigChangeType;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.configcenter.DynamicConfiguration;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;
import org.apache.dubbo.rpc.cluster.router.tag.model.TagRouterRule;
import org.apache.dubbo.rpc.cluster.router.tag.model.TagRuleParser;

public class TagRouter
extends AbstractRouter
implements Comparable<Router>,
ConfigurationListener {
    public static final String NAME = "TAG_ROUTER";
    private static final int DEFAULT_PRIORITY = 100;
    private static final Logger logger = LoggerFactory.getLogger(TagRouter.class);
    private static final String RULE_SUFFIX = ".tag-router";
    private TagRouterRule tagRouterRule;
    private String application;

    public TagRouter(DynamicConfiguration configuration, URL url) {
        super(configuration, url);
    }

    @Override
    public synchronized void process(ConfigChangeEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Notification of tag rule, change type is: " + (Object)((Object)event.getChangeType()) + ", raw rule is:\n " + event.getValue());
        }
        try {
            this.tagRouterRule = event.getChangeType().equals((Object)ConfigChangeType.DELETED) ? null : TagRuleParser.parse(event.getValue());
        }
        catch (Exception e) {
            logger.error("Failed to parse the raw tag router rule and it will not take effect, please check if the rule matches with the template, the raw rule is:\n ", e);
        }
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        String tag;
        if (CollectionUtils.isEmpty(invokers)) {
            return invokers;
        }
        if (this.tagRouterRule == null || !this.tagRouterRule.isValid() || !this.tagRouterRule.isEnabled()) {
            return this.filterUsingStaticTag(invokers, url, invocation);
        }
        List<Invoker<T>> result = invokers;
        String string = tag = StringUtils.isEmpty(invocation.getAttachment("dubbo.tag")) ? url.getParameter("dubbo.tag") : invocation.getAttachment("dubbo.tag");
        if (StringUtils.isNotEmpty(tag)) {
            List<String> addresses = this.tagRouterRule.getTagnameToAddresses().get(tag);
            if (CollectionUtils.isNotEmpty(addresses)) {
                result = this.filterInvoker(invokers, invoker -> this.addressMatches(invoker.getUrl(), addresses));
                if (CollectionUtils.isNotEmpty(result) || this.tagRouterRule.isForce()) {
                    return result;
                }
            } else {
                result = this.filterInvoker(invokers, invoker -> tag.equals(invoker.getUrl().getParameter("dubbo.tag")));
            }
            if (CollectionUtils.isNotEmpty(result) || this.isForceUseTag(invocation)) {
                return result;
            }
            List<Invoker<T>> tmp = this.filterInvoker(invokers, invoker -> this.addressNotMatches(invoker.getUrl(), this.tagRouterRule.getAddresses()));
            return this.filterInvoker(tmp, invoker -> StringUtils.isEmpty(invoker.getUrl().getParameter("dubbo.tag")));
        }
        List<String> addresses = this.tagRouterRule.getAddresses();
        if (CollectionUtils.isNotEmpty(addresses) && CollectionUtils.isEmpty(result = this.filterInvoker(invokers, invoker -> this.addressNotMatches(invoker.getUrl(), addresses)))) {
            return result;
        }
        return this.filterInvoker(result, invoker -> {
            String localTag = invoker.getUrl().getParameter("dubbo.tag");
            return StringUtils.isEmpty(localTag) || !this.tagRouterRule.getTagNames().contains(localTag);
        });
    }

    private <T> List<Invoker<T>> filterUsingStaticTag(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        String tag;
        List<Invoker<T>> result = invokers;
        String string = tag = StringUtils.isEmpty(invocation.getAttachment("dubbo.tag")) ? url.getParameter("dubbo.tag") : invocation.getAttachment("dubbo.tag");
        if (!StringUtils.isEmpty(tag)) {
            result = this.filterInvoker(invokers, invoker -> tag.equals(invoker.getUrl().getParameter("dubbo.tag")));
            if (CollectionUtils.isEmpty(result) && !this.isForceUseTag(invocation)) {
                result = this.filterInvoker(invokers, invoker -> StringUtils.isEmpty(invoker.getUrl().getParameter("dubbo.tag")));
            }
        } else {
            result = this.filterInvoker(invokers, invoker -> StringUtils.isEmpty(invoker.getUrl().getParameter("dubbo.tag")));
        }
        return result;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public boolean isRuntime() {
        return this.tagRouterRule != null && this.tagRouterRule.isRuntime();
    }

    @Override
    public boolean isForce() {
        return this.tagRouterRule != null && this.tagRouterRule.isForce();
    }

    private boolean isForceUseTag(Invocation invocation) {
        return Boolean.valueOf(invocation.getAttachment("dubbo.force.tag", this.url.getParameter("dubbo.force.tag", "false")));
    }

    private <T> List<Invoker<T>> filterInvoker(List<Invoker<T>> invokers, Predicate<Invoker<T>> predicate) {
        return invokers.stream().filter(predicate).collect(Collectors.toList());
    }

    private boolean addressMatches(URL url, List<String> addresses) {
        return addresses != null && addresses.contains(url.getAddress());
    }

    private boolean addressNotMatches(URL url, List<String> addresses) {
        return addresses == null || !addresses.contains(url.getAddress());
    }

    public void setApplication(String app) {
        this.application = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void notify(List<Invoker<T>> invokers) {
        if (invokers == null || invokers.isEmpty()) {
            return;
        }
        Invoker<T> invoker = invokers.get(0);
        URL url = invoker.getUrl();
        String providerApplication = url.getParameter("remote.application");
        if (StringUtils.isEmpty(providerApplication)) {
            logger.error("TagRouter must getConfig from or subscribe to a specific application, but the application in this TagRouter is not specified.");
            return;
        }
        TagRouter tagRouter = this;
        synchronized (tagRouter) {
            if (!providerApplication.equals(this.application)) {
                if (!StringUtils.isEmpty(this.application)) {
                    this.configuration.removeListener(this.application + RULE_SUFFIX, this);
                }
                String key = providerApplication + RULE_SUFFIX;
                this.configuration.addListener(key, this);
                this.application = providerApplication;
                String rawRule = this.configuration.getConfig(key);
                if (rawRule != null) {
                    this.process(new ConfigChangeEvent(key, rawRule));
                }
            }
        }
    }
}

