/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;

public class ConditionRouter
extends AbstractRouter
implements Comparable<Router> {
    public static final String NAME = "condition";
    private static final Logger logger = LoggerFactory.getLogger(ConditionRouter.class);
    protected static Pattern ROUTE_PATTERN = Pattern.compile("([&!=,]*)\\s*([^&!=,\\s]+)");
    protected Map<String, MatchPair> whenCondition;
    protected Map<String, MatchPair> thenCondition;
    private boolean enabled;

    public ConditionRouter(String rule, boolean force, boolean enabled) {
        this.force = force;
        this.enabled = enabled;
        this.init(rule);
    }

    public ConditionRouter(URL url) {
        this.url = url;
        this.priority = url.getParameter("priority", 0);
        this.force = url.getParameter("force", false);
        this.enabled = url.getParameter("enabled", true);
        this.init(url.getParameterAndDecoded("rule"));
    }

    public void init(String rule) {
        try {
            if (rule == null || rule.trim().length() == 0) {
                throw new IllegalArgumentException("Illegal route rule!");
            }
            int i = (rule = rule.replace("consumer.", "").replace("provider.", "")).indexOf("=>");
            String whenRule = i < 0 ? null : rule.substring(0, i).trim();
            String thenRule = i < 0 ? rule.trim() : rule.substring(i + 2).trim();
            HashMap<String, MatchPair> when = StringUtils.isBlank(whenRule) || "true".equals(whenRule) ? new HashMap<String, MatchPair>() : ConditionRouter.parseRule(whenRule);
            Map<String, MatchPair> then = StringUtils.isBlank(thenRule) || "false".equals(thenRule) ? null : ConditionRouter.parseRule(thenRule);
            this.whenCondition = when;
            this.thenCondition = then;
        }
        catch (ParseException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static Map<String, MatchPair> parseRule(String rule) throws ParseException {
        HashMap<String, MatchPair> condition = new HashMap<String, MatchPair>();
        if (StringUtils.isBlank(rule)) {
            return condition;
        }
        MatchPair pair = null;
        Set<String> values = null;
        Matcher matcher = ROUTE_PATTERN.matcher(rule);
        while (matcher.find()) {
            String separator = matcher.group(1);
            String content = matcher.group(2);
            if (separator == null || separator.length() == 0) {
                pair = new MatchPair();
                condition.put(content, pair);
                continue;
            }
            if ("&".equals(separator)) {
                if (condition.get(content) == null) {
                    pair = new MatchPair();
                    condition.put(content, pair);
                    continue;
                }
                pair = (MatchPair)condition.get(content);
                continue;
            }
            if ("=".equals(separator)) {
                if (pair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = pair.matches;
                values.add(content);
                continue;
            }
            if ("!=".equals(separator)) {
                if (pair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = pair.mismatches;
                values.add(content);
                continue;
            }
            if (",".equals(separator)) {
                if (values == null || values.isEmpty()) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values.add(content);
                continue;
            }
            throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
        }
        return condition;
    }

    @Override
    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        if (!this.enabled) {
            return invokers;
        }
        if (invokers == null || invokers.isEmpty()) {
            return invokers;
        }
        try {
            if (!this.matchWhen(url, invocation)) {
                return invokers;
            }
            ArrayList<Invoker<T>> result = new ArrayList<Invoker<T>>();
            if (this.thenCondition == null) {
                logger.warn("The current consumer in the service blacklist. consumer: " + NetUtils.getLocalHost() + ", service: " + url.getServiceKey());
                return result;
            }
            for (Invoker<T> invoker : invokers) {
                if (!this.matchThen(invoker.getUrl(), url)) continue;
                result.add(invoker);
            }
            if (!result.isEmpty()) {
                return result;
            }
            if (this.force) {
                logger.warn("The route result is empty and force execute. consumer: " + NetUtils.getLocalHost() + ", service: " + url.getServiceKey() + ", router: " + url.getParameterAndDecoded("rule"));
                return result;
            }
        }
        catch (Throwable t) {
            logger.error("Failed to execute condition router rule: " + this.getUrl() + ", invokers: " + invokers + ", cause: " + t.getMessage(), t);
        }
        return invokers;
    }

    @Override
    public boolean isRuntime() {
        return this.url.getParameter("runtime", false);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    boolean matchWhen(URL url, Invocation invocation) {
        return this.whenCondition == null || this.whenCondition.isEmpty() || this.matchCondition(this.whenCondition, url, null, invocation);
    }

    private boolean matchThen(URL url, URL param) {
        return this.thenCondition != null && !this.thenCondition.isEmpty() && this.matchCondition(this.thenCondition, url, param, null);
    }

    private boolean matchCondition(Map<String, MatchPair> condition, URL url, URL param, Invocation invocation) {
        Map<String, String> sample = url.toMap();
        boolean result = false;
        for (Map.Entry<String, MatchPair> matchPair : condition.entrySet()) {
            String sampleValue;
            String key = matchPair.getKey();
            if (invocation != null && ("method".equals(key) || "methods".equals(key))) {
                sampleValue = invocation.getMethodName();
            } else if ("address".equals(key)) {
                sampleValue = url.getAddress();
            } else if ("host".equals(key)) {
                sampleValue = url.getHost();
            } else {
                sampleValue = sample.get(key);
                if (sampleValue == null) {
                    sampleValue = sample.get("default." + key);
                }
            }
            if (sampleValue != null) {
                if (!matchPair.getValue().isMatch(sampleValue, param)) {
                    return false;
                }
                result = true;
                continue;
            }
            if (!matchPair.getValue().matches.isEmpty()) {
                return false;
            }
            result = true;
        }
        return result;
    }

    protected static final class MatchPair {
        final Set<String> matches = new HashSet<String>();
        final Set<String> mismatches = new HashSet<String>();

        protected MatchPair() {
        }

        private boolean isMatch(String value, URL param) {
            if (!this.matches.isEmpty() && this.mismatches.isEmpty()) {
                for (String match : this.matches) {
                    if (!UrlUtils.isMatchGlobPattern(match, value, param)) continue;
                    return true;
                }
                return false;
            }
            if (!this.mismatches.isEmpty() && this.matches.isEmpty()) {
                for (String mismatch : this.mismatches) {
                    if (!UrlUtils.isMatchGlobPattern(mismatch, value, param)) continue;
                    return false;
                }
                return true;
            }
            if (!this.matches.isEmpty() && !this.mismatches.isEmpty()) {
                for (String mismatch : this.mismatches) {
                    if (!UrlUtils.isMatchGlobPattern(mismatch, value, param)) continue;
                    return false;
                }
                for (String match : this.matches) {
                    if (!UrlUtils.isMatchGlobPattern(match, value, param)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

