/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.mina;

import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.Constants;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractClient;
import org.apache.dubbo.remoting.transport.mina.MinaChannel;
import org.apache.dubbo.remoting.transport.mina.MinaCodecAdapter;
import org.apache.dubbo.remoting.transport.mina.MinaHandler;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public class MinaClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(MinaClient.class);
    private static final Map<String, SocketConnector> connectors = new ConcurrentHashMap<String, SocketConnector>();
    private String connectorKey;
    private SocketConnector connector;
    private volatile IoSession session;

    public MinaClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, MinaClient.wrapChannelHandler(url, handler));
    }

    @Override
    protected void doOpen() throws Throwable {
        this.connectorKey = this.getUrl().toFullString();
        SocketConnector c = connectors.get(this.connectorKey);
        if (c != null) {
            this.connector = c;
        } else {
            this.connector = new SocketConnector(Constants.DEFAULT_IO_THREADS, (Executor)Executors.newCachedThreadPool(new NamedThreadFactory("MinaClientWorker", true)));
            SocketConnectorConfig cfg = this.connector.getDefaultConfig();
            cfg.setThreadModel(ThreadModel.MANUAL);
            cfg.getSessionConfig().setTcpNoDelay(true);
            cfg.getSessionConfig().setKeepAlive(true);
            int timeout = this.getConnectTimeout();
            cfg.setConnectTimeout(timeout < 1000 ? 1 : timeout / 1000);
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new MinaCodecAdapter(this.getCodec(), this.getUrl(), this)));
            connectors.put(this.connectorKey, this.connector);
        }
    }

    @Override
    protected void doConnect() throws Throwable {
        ConnectFuture future = this.connector.connect((SocketAddress)this.getConnectAddress(), (IoHandler)new MinaHandler(this.getUrl(), this));
        long start = System.currentTimeMillis();
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch finish = new CountDownLatch(1);
        future.addListener(new IoFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(IoFuture future) {
                block20: {
                    try {
                        if (!future.isReady()) break block20;
                        IoSession newSession = future.getSession();
                        try {
                            IoSession oldSession = MinaClient.this.session;
                            if (oldSession == null) break block20;
                            try {
                                if (logger.isInfoEnabled()) {
                                    logger.info("Close old mina channel " + oldSession + " on create new mina channel " + newSession);
                                }
                                oldSession.close();
                            }
                            finally {
                                MinaChannel.removeChannelIfDisconnected(oldSession);
                            }
                        }
                        finally {
                            if (MinaClient.this.isClosed()) {
                                try {
                                    if (logger.isInfoEnabled()) {
                                        logger.info("Close new mina channel " + newSession + ", because the client closed.");
                                    }
                                    newSession.close();
                                }
                                finally {
                                    MinaClient.this.session = null;
                                    MinaChannel.removeChannelIfDisconnected(newSession);
                                }
                            } else {
                                MinaClient.this.session = newSession;
                            }
                        }
                    }
                    catch (Exception e) {
                        exception.set(e);
                    }
                    finally {
                        finish.countDown();
                    }
                }
            }
        });
        try {
            finish.await(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RemotingException(this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion() + ", cause: " + e.getMessage(), (Throwable)e);
        }
        Throwable e = (Throwable)exception.get();
        if (e != null) {
            throw e;
        }
    }

    @Override
    protected void doDisConnect() throws Throwable {
        try {
            MinaChannel.removeChannelIfDisconnected(this.session);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    @Override
    protected void doClose() throws Throwable {
    }

    @Override
    protected Channel getChannel() {
        IoSession s = this.session;
        if (s == null || !s.isConnected()) {
            return null;
        }
        return MinaChannel.getOrAddChannel(s, this.getUrl(), this);
    }
}

