/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.DefaultTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class MapTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        if (!(type instanceof ParameterizedType)) {
            return new TypeDefinition(clazz.getName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        if (actualTypeArgs == null || actualTypeArgs.length != 2) {
            throw new IllegalArgumentException(MessageFormat.format("[ServiceDefinitionBuilder] Map type [{0}] with unexpected amount of arguments [{1}]." + actualTypeArgs, type, actualTypeArgs));
        }
        for (Type actualType : actualTypeArgs) {
            if (actualType instanceof ParameterizedType) {
                Class rawType = (Class)((ParameterizedType)actualType).getRawType();
                TypeDefinitionBuilder.build(actualType, rawType, typeCache);
                continue;
            }
            if (!(actualType instanceof Class)) continue;
            Class actualClass = (Class)actualType;
            if (actualClass.isArray() || actualClass.isEnum()) {
                TypeDefinitionBuilder.build(null, actualClass, typeCache);
                continue;
            }
            DefaultTypeBuilder.build(actualClass, typeCache);
        }
        return new TypeDefinition(type.toString());
    }
}

