/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class ConfigCenterBean
extends ConfigCenterConfig
implements InitializingBean,
ApplicationContextAware,
DisposableBean,
EnvironmentAware {
    private transient ApplicationContext applicationContext;
    private Boolean includeSpringEnv = false;
    private ApplicationConfig application;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getApplication() == null) {
            Map applicationConfigMap;
            Map map = applicationConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ApplicationConfig.class, (boolean)false, (boolean)false);
            if (applicationConfigMap != null && applicationConfigMap.size() > 0) {
                ApplicationConfig applicationConfig = null;
                for (ApplicationConfig config : applicationConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (applicationConfig != null) {
                        throw new IllegalStateException("Duplicate application configs: " + applicationConfig + " and " + config);
                    }
                    applicationConfig = config;
                }
                if (applicationConfig != null) {
                    this.setApplication(applicationConfig);
                }
            }
        }
    }

    public void destroy() throws Exception {
    }

    public void setEnvironment(Environment environment) {
        if (this.includeSpringEnv.booleanValue()) {
            Map<String, String> externalProperties = this.getConfigurations(this.getConfigFile(), environment);
            Map<String, String> appExternalProperties = this.getConfigurations(StringUtils.isNotEmpty(this.getAppConfigFile()) ? this.getAppConfigFile() : (StringUtils.isEmpty(this.getAppName()) ? "application." + this.getConfigFile() : this.getAppName() + "." + this.getConfigFile()), environment);
            org.apache.dubbo.common.config.Environment.getInstance().setExternalConfigMap(externalProperties);
            org.apache.dubbo.common.config.Environment.getInstance().setAppExternalConfigMap(appExternalProperties);
        }
    }

    private Map<String, String> getConfigurations(String key, Environment environment) {
        Object rawProperties = environment.getProperty(key, Object.class);
        HashMap<String, String> externalProperties = new HashMap<String, String>();
        try {
            Object source;
            ConfigurableEnvironment configurableEnvironment;
            PropertySource propertySource;
            if (rawProperties instanceof Map) {
                externalProperties.putAll((Map)rawProperties);
            } else if (rawProperties instanceof String) {
                externalProperties.putAll(ConfigurationUtils.parseProperties((String)rawProperties));
            }
            if (environment instanceof ConfigurableEnvironment && externalProperties.isEmpty() && (propertySource = (configurableEnvironment = (ConfigurableEnvironment)environment).getPropertySources().get(key)) != null && (source = propertySource.getSource()) instanceof Map) {
                ((Map)source).forEach((k, v) -> externalProperties.put((String)k, (String)v));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return externalProperties;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Boolean getIncludeSpringEnv() {
        return this.includeSpringEnv;
    }

    public void setIncludeSpringEnv(Boolean includeSpringEnv) {
        this.includeSpringEnv = includeSpringEnv;
    }

    public ApplicationConfig getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationConfig application) {
        this.application = application;
    }
}

