/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.ShellExecutor;

public class OSUtils {
    private OSUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getSudoCmd(String tenantCode, String command) {
        return StringUtils.isEmpty((CharSequence)tenantCode) || !OSUtils.isSudoEnable() ? command : "sudo -u " + tenantCode + " " + command;
    }

    public static boolean isSudoEnable() {
        return PropertyUtils.getBoolean((String)"sudo.enable", (boolean)Boolean.TRUE);
    }

    public static String exeCmd(String command) throws IOException {
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArray[i] = st.nextToken();
            ++i;
        }
        return OSUtils.exeShell(cmdArray);
    }

    public static String exeShell(String[] command) throws IOException {
        return ShellExecutor.execCommand(command);
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }
}

