/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.loop.template.http;

import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.loop.BaseLoopTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskInstanceInfo;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskInstanceStatus;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.HttpLoopTaskDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.parser.HttpTaskDefinitionParser;

public abstract class BaseHttpTemplateLoopTaskExecutor
extends BaseLoopTaskExecutor {
    private final HttpLoopTaskDefinition httpLoopTaskDefinition;

    public BaseHttpTemplateLoopTaskExecutor(@NonNull TaskExecutionContext taskExecutionContext, @NonNull String taskDefinitionYamlFile) {
        super(taskExecutionContext);
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        if (taskDefinitionYamlFile == null) {
            throw new NullPointerException("taskDefinitionYamlFile is marked non-null but is null");
        }
        this.httpLoopTaskDefinition = new HttpTaskDefinitionParser().parse(taskDefinitionYamlFile);
    }

    @Override
    @NonNull
    public LoopTaskInstanceInfo submitLoopTask() {
        return this.httpLoopTaskDefinition.getSubmitTaskMethod().submitLoopTask();
    }

    @Override
    @NonNull
    public LoopTaskInstanceStatus queryTaskInstanceStatus(@NonNull LoopTaskInstanceInfo taskInstanceInfo) {
        if (taskInstanceInfo == null) {
            throw new NullPointerException("taskInstanceInfo is marked non-null but is null");
        }
        return this.httpLoopTaskDefinition.getQueryTaskStateMethod().queryTaskInstanceStatus(taskInstanceInfo);
    }

    @Override
    public void cancelLoopTaskInstance(@Nullable LoopTaskInstanceInfo taskInstanceInfo) {
        if (taskInstanceInfo == null) {
            return;
        }
        this.httpLoopTaskDefinition.getCancelTaskMethod().cancelTaskInstance(taskInstanceInfo);
    }
}

