/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.k8s;

import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.utils.K8sUtils;
import org.slf4j.Logger;

public abstract class AbstractK8sTaskExecutor {
    protected Logger logger;
    protected TaskExecutionContext taskRequest;
    protected K8sUtils k8sUtils;
    protected StringBuilder logStringBuffer;

    protected AbstractK8sTaskExecutor(Logger logger, TaskExecutionContext taskRequest) {
        this.logger = logger;
        this.taskRequest = taskRequest;
        this.k8sUtils = new K8sUtils();
        this.logStringBuffer = new StringBuilder();
    }

    public abstract TaskResponse run(String var1) throws Exception;

    public abstract void cancelApplication(String var1);

    public void waitTimeout(Boolean timeout) throws TaskException {
        if (Boolean.TRUE.equals(timeout)) {
            throw new TaskException("K8sTask is timeout");
        }
    }

    public void flushLog(TaskResponse taskResponse) {
        if (this.logStringBuffer.length() != 0 && taskResponse.getExitStatusCode() == -1) {
            this.logger.error(this.logStringBuffer.toString());
        } else if (this.logStringBuffer.length() != 0) {
            this.logger.info(this.logStringBuffer.toString());
        }
    }

    public abstract void submitJob2k8s(String var1);

    public abstract void stopJobOnK8s(String var1);
}

