/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.impl.sql.catalog.TableKey;

class SPSNameCacheable
implements Cacheable {
    private TableKey identity;
    private SPSDescriptor spsd;
    private final DataDictionaryImpl dd;

    SPSNameCacheable(DataDictionaryImpl dataDictionaryImpl) {
        this.dd = dataDictionaryImpl;
    }

    public void clearIdentity() {
        if (this.spsd != null) {
            this.dd.spsCacheEntryRemoved(this.spsd);
            this.spsd = null;
            this.identity = null;
        }
    }

    public Object getIdentity() {
        return this.identity;
    }

    public Cacheable createIdentity(Object object, Object object2) {
        this.identity = (TableKey)object;
        this.spsd = (SPSDescriptor)object2;
        if (this.spsd != null) {
            this.dd.spsCacheEntryAdded(this.spsd);
            try {
                this.spsd.loadGeneratedClass();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            return this;
        }
        return null;
    }

    public Cacheable setIdentity(Object object) throws StandardException {
        this.identity = (TableKey)object;
        this.spsd = this.dd.getUncachedSPSDescriptor(this.identity);
        if (this.spsd != null) {
            this.dd.spsCacheEntryAdded(this.spsd);
            try {
                this.spsd.loadGeneratedClass();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            return this;
        }
        return null;
    }

    public void clean(boolean bl) {
    }

    public boolean isDirty() {
        return false;
    }

    public SPSDescriptor getSPSDescriptor() {
        return this.spsd;
    }

    private boolean checkConsistency(SPSDescriptor sPSDescriptor, Object object, HeaderPrintWriter headerPrintWriter) throws StandardException {
        boolean bl = true;
        return bl;
    }
}

