/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.info;

import org.apache.camel.CamelContext;
import org.apache.camel.support.CamelContextHelper;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;

public class CamelInfoContributor
implements InfoContributor {
    private final CamelContext camelContext;

    public CamelInfoContributor(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void contribute(Info.Builder builder) {
        if (this.camelContext != null) {
            builder.withDetail("camel.name", (Object)this.camelContext.getName());
            builder.withDetail("camel.version", (Object)this.camelContext.getVersion());
            if (this.camelContext.getUptime() != null) {
                builder.withDetail("camel.uptime", (Object)CamelContextHelper.getUptime((CamelContext)this.camelContext));
                builder.withDetail("camel.uptimeMillis", (Object)CamelContextHelper.getUptimeMillis((CamelContext)this.camelContext));
            }
            builder.withDetail("camel.status", (Object)this.camelContext.getStatus().name());
        }
    }
}

