/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.springboot.cluster;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.file.cluster.FileLockClusterService;
import org.apache.camel.component.file.springboot.cluster.FileLockClusterServiceConfiguration;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.cluster.ClusteredRouteControllerAutoConfiguration;
import org.apache.camel.spring.boot.cluster.TimePatternConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@AutoConfigureBefore(value={ClusteredRouteControllerAutoConfiguration.class, CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="camel.component.file.cluster.service", name={"enabled"})
@EnableConfigurationProperties(value={FileLockClusterServiceConfiguration.class})
public class FileLockClusterServiceAutoConfiguration {
    @Autowired
    private FileLockClusterServiceConfiguration configuration;

    @Bean(name={"file-lock-cluster-service"})
    @Scope(value="singleton")
    public CamelClusterService fileClusterService() throws Exception {
        FileLockClusterService service = new FileLockClusterService();
        Optional.ofNullable(this.configuration.getId()).ifPresent(arg_0 -> ((FileLockClusterService)service).setId(arg_0));
        Optional.ofNullable(this.configuration.getRoot()).ifPresent(arg_0 -> ((FileLockClusterService)service).setRoot(arg_0));
        Optional.ofNullable(this.configuration.getOrder()).ifPresent(arg_0 -> ((FileLockClusterService)service).setOrder(arg_0));
        Optional.ofNullable(this.configuration.getAttributes()).ifPresent(arg_0 -> ((FileLockClusterService)service).setAttributes(arg_0));
        Optional.ofNullable(this.configuration.getAcquireLockDelay()).map(TimePatternConverter::toMilliSeconds).ifPresent(v -> service.setAcquireLockDelay(v.longValue(), TimeUnit.MILLISECONDS));
        Optional.ofNullable(this.configuration.getAcquireLockInterval()).map(TimePatternConverter::toMilliSeconds).ifPresent(v -> service.setAcquireLockInterval(v.longValue(), TimeUnit.MILLISECONDS));
        return service;
    }
}

