/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.header.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.language.header.HeaderLanguage;
import org.apache.camel.language.header.springboot.HeaderLanguageConfiguration;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.LanguageConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={LanguageConfigurationProperties.class, HeaderLanguageConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.language", "camel.language.header"})
public class HeaderLanguageAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private HeaderLanguageConfiguration configuration;

    public HeaderLanguageAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public LanguageCustomizer configureHeaderLanguage() {
        return new LanguageCustomizer(){

            public void configure(String name, Language target) {
                CamelPropertiesHelper.copyProperties((CamelContext)HeaderLanguageAutoConfiguration.this.camelContext, (Object)((Object)HeaderLanguageAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Language target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)HeaderLanguageAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.language.customizer", "camel.language.header.customizer"}) && target instanceof HeaderLanguage;
            }
        };
    }
}

