/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.SortedSetMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.core.Snapshot;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.stream.LogicalChi;
import org.apache.calcite.rel.stream.LogicalDelta;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitDispatcher;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;

public class RelStructuredTypeFlattener
implements ReflectiveVisitor {
    private final RelBuilder relBuilder;
    private final RexBuilder rexBuilder;
    private final boolean restructure;
    private final Map<RelNode, RelNode> oldToNewRelMap = new HashMap<RelNode, RelNode>();
    private RelNode currentRel;
    private int iRestructureInput;
    private RelDataType flattenedRootType;
    boolean restructured;
    private final RelOptTable.ToRelContext toRelContext;

    @Deprecated
    public RelStructuredTypeFlattener(RexBuilder rexBuilder, RelOptTable.ToRelContext toRelContext, boolean restructure) {
        this(RelFactories.LOGICAL_BUILDER.create(toRelContext.getCluster(), null), rexBuilder, toRelContext, restructure);
    }

    public RelStructuredTypeFlattener(RelBuilder relBuilder, RexBuilder rexBuilder, RelOptTable.ToRelContext toRelContext, boolean restructure) {
        this.relBuilder = relBuilder;
        this.rexBuilder = rexBuilder;
        this.toRelContext = toRelContext;
        this.restructure = restructure;
    }

    public void updateRelInMap(SortedSetMultimap<RelNode, CorrelationId> mapRefRelToCorVar) {
        for (RelNode rel : Lists.newArrayList((Iterable)mapRefRelToCorVar.keySet())) {
            if (!this.oldToNewRelMap.containsKey(rel)) continue;
            SortedSet corVarSet = mapRefRelToCorVar.removeAll((Object)rel);
            mapRefRelToCorVar.putAll((Object)this.oldToNewRelMap.get(rel), (Iterable)corVarSet);
        }
    }

    public void updateRelInMap(SortedMap<CorrelationId, LogicalCorrelate> mapCorVarToCorRel) {
        for (CorrelationId corVar : mapCorVarToCorRel.keySet()) {
            LogicalCorrelate oldRel = (LogicalCorrelate)mapCorVarToCorRel.get(corVar);
            if (!this.oldToNewRelMap.containsKey(oldRel)) continue;
            RelNode newRel = this.oldToNewRelMap.get(oldRel);
            assert (newRel instanceof LogicalCorrelate);
            mapCorVarToCorRel.put(corVar, (LogicalCorrelate)newRel);
        }
    }

    public RelNode rewrite(RelNode root) {
        RewriteRelVisitor visitor = new RewriteRelVisitor();
        visitor.visit(root, 0, null);
        RelNode flattened = this.getNewForOldRel(root);
        this.flattenedRootType = flattened.getRowType();
        this.restructured = false;
        List<RexNode> structuringExps = null;
        if (this.restructure) {
            this.iRestructureInput = 0;
            structuringExps = this.restructureFields(root.getRowType());
        }
        if (this.restructured) {
            return this.relBuilder.push(flattened).projectNamed(structuringExps, root.getRowType().getFieldNames(), true).build();
        }
        return flattened;
    }

    private List<RexNode> restructureFields(RelDataType structuredType) {
        ArrayList<RexNode> structuringExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : structuredType.getFieldList()) {
            if (field.getType().getSqlTypeName() == SqlTypeName.STRUCTURED) {
                this.restructured = true;
                structuringExps.add(this.restructure(field.getType()));
                continue;
            }
            structuringExps.add(new RexInputRef(this.iRestructureInput, field.getType()));
            ++this.iRestructureInput;
        }
        return structuringExps;
    }

    private RexNode restructure(RelDataType structuredType) {
        RexInputRef nullIndicator = RexInputRef.of(this.iRestructureInput++, this.flattenedRootType.getFieldList());
        List<RexNode> inputExprs = this.restructureFields(structuredType);
        RexNode newInvocation = this.rexBuilder.makeNewInvocation(structuredType, inputExprs);
        if (!structuredType.isNullable()) {
            return newInvocation;
        }
        RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, nullIndicator), this.rexBuilder.makeCast(structuredType, this.rexBuilder.constantNull()), newInvocation};
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
    }

    protected void setNewForOldRel(RelNode oldRel, RelNode newRel) {
        this.oldToNewRelMap.put(oldRel, newRel);
    }

    protected RelNode getNewForOldRel(RelNode oldRel) {
        return this.oldToNewRelMap.get(oldRel);
    }

    protected int getNewForOldInput(int oldOrdinal) {
        return this.getNewFieldForOldInput((int)oldOrdinal).i;
    }

    private Ord<RelDataType> getNewFieldForOldInput(int oldOrdinal, int existingOffset) {
        assert (this.currentRel != null);
        int newOrdinal = 0;
        RelNode oldInput = null;
        RelNode newInput = null;
        for (RelNode oldInput1 : this.currentRel.getInputs()) {
            newInput = this.getNewForOldRel(oldInput1);
            RelDataType oldInputType = oldInput1.getRowType();
            int n = oldInputType.getFieldCount();
            if (oldOrdinal < n) {
                oldInput = oldInput1;
                break;
            }
            newOrdinal += newInput.getRowType().getFieldCount();
            oldOrdinal -= n;
        }
        assert (oldInput != null);
        assert (newInput != null);
        RelDataType oldInputType = oldInput.getRowType();
        int newOffset = this.calculateFlattenedOffset(oldInputType, oldOrdinal) + existingOffset;
        RelDataTypeField field = newInput.getRowType().getFieldList().get(newOffset);
        return Ord.of((int)(newOrdinal += newOffset), (Object)field.getType());
    }

    protected Ord<RelDataType> getNewFieldForOldInput(int oldOrdinal) {
        return this.getNewFieldForOldInput(oldOrdinal, 0);
    }

    private Mappings.TargetMapping getNewForOldInputMapping(RelNode oldRel) {
        RelNode newRel = this.getNewForOldRel(oldRel);
        return Mappings.target(this::getNewForOldInput, oldRel.getRowType().getFieldCount(), newRel.getRowType().getFieldCount());
    }

    private int calculateFlattenedOffset(RelDataType rowType, int ordinal) {
        int offset = 0;
        if (SqlTypeUtil.needsNullIndicator(rowType)) {
            ++offset;
        }
        List<RelDataTypeField> oldFields = rowType.getFieldList();
        for (int i = 0; i < ordinal; ++i) {
            RelDataType oldFieldType = oldFields.get(i).getType();
            if (oldFieldType.isStruct()) {
                RelDataType flattened = SqlTypeUtil.flattenRecordType(this.rexBuilder.getTypeFactory(), oldFieldType, null);
                List<RelDataTypeField> fields = flattened.getFieldList();
                offset += fields.size();
                continue;
            }
            ++offset;
        }
        return offset;
    }

    public void rewriteRel(LogicalTableModify rel) {
        LogicalTableModify newRel = LogicalTableModify.create(rel.getTable(), rel.getCatalogReader(), this.getNewForOldRel(rel.getInput()), rel.getOperation(), rel.getUpdateColumnList(), rel.getSourceExpressionList(), true);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalAggregate rel) {
        RelDataType inputType = rel.getInput().getRowType();
        for (RelDataTypeField field : inputType.getFieldList()) {
            if (!field.getType().isStruct()) continue;
            throw Util.needToImplement("aggregation on structured types");
        }
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(Sort rel) {
        RelCollation oldCollation = rel.getCollation();
        RelNode oldChild = rel.getInput();
        RelNode newChild = this.getNewForOldRel(oldChild);
        Mappings.TargetMapping mapping = this.getNewForOldInputMapping(oldChild);
        for (RelFieldCollation field : oldCollation.getFieldCollations()) {
            int oldInput = field.getFieldIndex();
            RelDataType sortFieldType = oldChild.getRowType().getFieldList().get(oldInput).getType();
            if (!sortFieldType.isStruct()) continue;
            throw Util.needToImplement("sorting on structured types");
        }
        RelCollation newCollation = RexUtil.apply(mapping, oldCollation);
        LogicalSort newRel = LogicalSort.create(newChild, newCollation, rel.offset, rel.fetch);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalFilter rel) {
        LogicalFilter newRel = rel.copy(rel.getTraitSet(), this.getNewForOldRel(rel.getInput()), rel.getCondition().accept(new RewriteRexShuttle()));
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalJoin rel) {
        LogicalJoin newRel = LogicalJoin.create(this.getNewForOldRel(rel.getLeft()), this.getNewForOldRel(rel.getRight()), rel.getCondition().accept(new RewriteRexShuttle()), rel.getVariablesSet(), rel.getJoinType());
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalCorrelate rel) {
        ImmutableBitSet.Builder newPos = ImmutableBitSet.builder();
        for (int pos : rel.getRequiredColumns()) {
            RelDataType corrFieldType = rel.getLeft().getRowType().getFieldList().get(pos).getType();
            if (corrFieldType.isStruct()) {
                throw Util.needToImplement("correlation on structured type");
            }
            newPos.set(this.getNewForOldInput(pos));
        }
        LogicalCorrelate newRel = LogicalCorrelate.create(this.getNewForOldRel(rel.getLeft()), this.getNewForOldRel(rel.getRight()), rel.getCorrelationId(), newPos.build(), rel.getJoinType());
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(Collect rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(Uncollect rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalIntersect rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalMinus rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalUnion rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalValues rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalTableFunctionScan rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(Sample rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalProject rel) {
        ArrayList<Pair<RexNode, String>> flattenedExpList = new ArrayList<Pair<RexNode, String>>();
        this.flattenProjections(new RewriteRexShuttle(), rel.getProjects(), rel.getRowType().getFieldNames(), "", flattenedExpList);
        this.relBuilder.push(this.getNewForOldRel(rel.getInput())).projectNamed(Pair.left(flattenedExpList), Pair.right(flattenedExpList), true);
        this.setNewForOldRel(rel, this.relBuilder.build());
    }

    public void rewriteRel(LogicalCalc rel) {
        RelNode newInput = this.getNewForOldRel(rel.getInput());
        RelOptCluster cluster = rel.getCluster();
        RexProgramBuilder programBuilder = new RexProgramBuilder(newInput.getRowType(), cluster.getRexBuilder());
        RexProgram program = rel.getProgram();
        RewriteRexShuttle shuttle = new RewriteRexShuttle();
        for (RexNode expr : program.getExprList()) {
            programBuilder.registerInput(expr.accept(shuttle));
        }
        ArrayList<Pair<RexNode, String>> flattenedExpList = new ArrayList<Pair<RexNode, String>>();
        List<String> fieldNames = rel.getRowType().getFieldNames();
        this.flattenProjections(new RewriteRexShuttle(), program.getProjectList(), fieldNames, "", flattenedExpList);
        for (Pair pair : flattenedExpList) {
            programBuilder.addProject((RexNode)pair.left, (String)pair.right);
        }
        RexLocalRef conditionRef = program.getCondition();
        if (conditionRef != null) {
            Ord<RelDataType> ord = this.getNewFieldForOldInput(conditionRef.getIndex());
            programBuilder.addCondition(new RexLocalRef(ord.i, (RelDataType)ord.e));
        }
        RexProgram rexProgram = programBuilder.getProgram();
        LogicalCalc newRel = LogicalCalc.create(newInput, rexProgram);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(SelfFlatteningRel rel) {
        rel.flattenRel(this);
    }

    public void rewriteGeneric(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        List<RelNode> oldInputs = rel.getInputs();
        for (int i = 0; i < oldInputs.size(); ++i) {
            newRel.replaceInput(i, this.getNewForOldRel(oldInputs.get(i)));
        }
        this.setNewForOldRel(rel, newRel);
    }

    private void flattenProjections(RewriteRexShuttle shuttle, List<? extends RexNode> exps, List<String> fieldNames, String prefix, List<Pair<RexNode, String>> flattenedExps) {
        for (int i = 0; i < exps.size(); ++i) {
            String fieldName;
            RexNode exp = exps.get(i);
            String string = fieldName = fieldNames == null || fieldNames.get(i) == null ? "$" + i : fieldNames.get(i);
            if (!prefix.equals("")) {
                fieldName = prefix + "$" + fieldName;
            }
            this.flattenProjection(shuttle, exp, fieldName, flattenedExps);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flattenProjection(RewriteRexShuttle shuttle, RexNode exp, String fieldName, List<Pair<RexNode, String>> flattenedExps) {
        if (exp.getType().isStruct()) {
            if (exp instanceof RexInputRef) {
                RexInputRef inputRef = (RexInputRef)exp;
                RelDataType flattenedType = SqlTypeUtil.flattenRecordType(this.rexBuilder.getTypeFactory(), exp.getType(), null);
                List<RelDataTypeField> fieldList = flattenedType.getFieldList();
                int n = fieldList.size();
                for (int j = 0; j < n; ++j) {
                    Ord<RelDataType> newField = this.getNewFieldForOldInput(inputRef.getIndex(), j);
                    flattenedExps.add(Pair.of(new RexInputRef(newField.i, (RelDataType)newField.e), fieldName));
                }
                return;
            } else if (this.isConstructor(exp) || exp.isA(SqlKind.CAST)) {
                RexCall call = (RexCall)exp;
                if (exp.isA(SqlKind.NEW_SPECIFICATION)) {
                    flattenedExps.add(Pair.of(this.rexBuilder.makeLiteral(false), fieldName));
                } else if (exp.isA(SqlKind.CAST) && RexLiteral.isNullLiteral((RexNode)((RexCall)exp).operands.get(0))) {
                    this.flattenNullLiteral(exp.getType(), flattenedExps);
                    return;
                }
                this.flattenProjections(new RewriteRexShuttle(), call.getOperands(), Collections.nCopies(call.getOperands().size(), null), fieldName, flattenedExps);
                return;
            } else {
                if (!(exp instanceof RexCall)) throw Util.needToImplement(exp);
                int j = 0;
                RexNode newExp = exp;
                List<RexNode> oldOperands = ((RexCall)exp).getOperands();
                if (oldOperands.get(0) instanceof RexInputRef) {
                    RexInputRef inputRef = (RexInputRef)oldOperands.get(0);
                    Ord<RelDataType> newField = this.getNewFieldForOldInput(inputRef.getIndex());
                    newExp = this.rexBuilder.makeCall(exp.getType(), ((RexCall)exp).getOperator(), (List<RexNode>)ImmutableList.of((Object)this.rexBuilder.makeInputRef((RelDataType)newField.e, newField.i), (Object)oldOperands.get(1)));
                }
                for (RelDataTypeField field : newExp.getType().getFieldList()) {
                    flattenedExps.add(Pair.of(this.rexBuilder.makeFieldAccess(newExp, field.getIndex()), fieldName + "$" + j++));
                }
            }
            return;
        } else {
            flattenedExps.add(Pair.of(exp.accept(shuttle), fieldName));
        }
    }

    private void flattenNullLiteral(RelDataType type, List<Pair<RexNode, String>> flattenedExps) {
        RelDataType flattenedType = SqlTypeUtil.flattenRecordType(this.rexBuilder.getTypeFactory(), type, null);
        for (RelDataTypeField field : flattenedType.getFieldList()) {
            flattenedExps.add(Pair.of(this.rexBuilder.makeCast(field.getType(), this.rexBuilder.constantNull()), field.getName()));
        }
    }

    private boolean isConstructor(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)rexNode;
        return call.getOperator().getName().equalsIgnoreCase("row") || call.isA(SqlKind.NEW_SPECIFICATION);
    }

    public void rewriteRel(TableScan rel) {
        RelNode newRel = rel.getTable().toRel(this.toRelContext);
        if (!SqlTypeUtil.isFlat(rel.getRowType())) {
            ArrayList<Pair<RexNode, String>> flattenedExpList = new ArrayList<Pair<RexNode, String>>();
            this.flattenInputs(rel.getRowType().getFieldList(), this.rexBuilder.makeRangeReference(newRel), flattenedExpList);
            newRel = this.relBuilder.push(newRel).projectNamed(Pair.left(flattenedExpList), Pair.right(flattenedExpList), true).build();
        }
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalSnapshot rel) {
        Snapshot newRel = rel.copy(rel.getTraitSet(), this.getNewForOldRel(rel.getInput()), rel.getPeriod().accept(new RewriteRexShuttle()));
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalDelta rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalChi rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalMatch rel) {
        this.rewriteGeneric(rel);
    }

    private void flattenInputs(List<RelDataTypeField> fieldList, RexNode prefix, List<Pair<RexNode, String>> flattenedExpList) {
        for (RelDataTypeField field : fieldList) {
            RexNode ref = this.rexBuilder.makeFieldAccess(prefix, field.getIndex());
            if (field.getType().isStruct()) {
                this.flattenInputs(field.getType().getFieldList(), ref, flattenedExpList);
                continue;
            }
            flattenedExpList.add(Pair.of(ref, field.getName()));
        }
    }

    private class RewriteRexShuttle
    extends RexShuttle {
        private RewriteRexShuttle() {
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            int oldIndex = input.getIndex();
            Ord<RelDataType> field = RelStructuredTypeFlattener.this.getNewFieldForOldInput(oldIndex);
            RelDataType fieldType = this.removeDistinct((RelDataType)field.e);
            return new RexInputRef(field.i, fieldType);
        }

        private RelDataType removeDistinct(RelDataType type) {
            if (type.getSqlTypeName() != SqlTypeName.DISTINCT) {
                return type;
            }
            return type.getFieldList().get(0).getType();
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode refExp;
            int iInput = 0;
            ArrayDeque<Integer> accessOrdinals = new ArrayDeque<Integer>();
            while (true) {
                refExp = fieldAccess.getReferenceExpr();
                int ordinal = fieldAccess.getField().getIndex();
                accessOrdinals.push(ordinal);
                iInput += RelStructuredTypeFlattener.this.calculateFlattenedOffset(refExp.getType(), ordinal);
                if (refExp instanceof RexInputRef) {
                    RexInputRef inputRef = (RexInputRef)refExp;
                    Ord newField = RelStructuredTypeFlattener.this.getNewFieldForOldInput(inputRef.getIndex(), iInput);
                    return new RexInputRef(newField.getKey(), this.removeDistinct((RelDataType)newField.getValue()));
                }
                if (refExp instanceof RexCorrelVariable) {
                    RelDataType refType = SqlTypeUtil.flattenRecordType(RelStructuredTypeFlattener.this.rexBuilder.getTypeFactory(), refExp.getType(), null);
                    refExp = RelStructuredTypeFlattener.this.rexBuilder.makeCorrel(refType, ((RexCorrelVariable)refExp).id);
                    return RelStructuredTypeFlattener.this.rexBuilder.makeFieldAccess(refExp, iInput);
                }
                if (refExp instanceof RexCall) {
                    RexCall call = (RexCall)refExp;
                    RexNode newRefExp = this.visitCall(call);
                    for (Integer ord : accessOrdinals) {
                        newRefExp = RelStructuredTypeFlattener.this.rexBuilder.makeFieldAccess(newRefExp, ord);
                    }
                    return newRefExp;
                }
                if (!(refExp instanceof RexFieldAccess)) break;
                fieldAccess = (RexFieldAccess)refExp;
            }
            throw Util.needToImplement(refExp);
        }

        @Override
        public RexNode visitCall(RexCall rexCall) {
            if (rexCall.isA(SqlKind.CAST)) {
                RexNode input = rexCall.getOperands().get(0).accept(this);
                RelDataType targetType = this.removeDistinct(rexCall.getType());
                return RelStructuredTypeFlattener.this.rexBuilder.makeCast(targetType, input);
            }
            if (!rexCall.isA(SqlKind.COMPARISON)) {
                return super.visitCall(rexCall);
            }
            RexNode lhs = rexCall.getOperands().get(0);
            if (!lhs.getType().isStruct()) {
                return super.visitCall(rexCall);
            }
            return this.flattenComparison(RelStructuredTypeFlattener.this.rexBuilder, rexCall.getOperator(), rexCall.getOperands());
        }

        @Override
        public RexNode visitSubQuery(RexSubQuery subQuery) {
            subQuery = (RexSubQuery)super.visitSubQuery(subQuery);
            RelStructuredTypeFlattener flattener = new RelStructuredTypeFlattener(RelStructuredTypeFlattener.this.relBuilder, RelStructuredTypeFlattener.this.rexBuilder, RelStructuredTypeFlattener.this.toRelContext, RelStructuredTypeFlattener.this.restructure);
            RelNode rel = flattener.rewrite(subQuery.rel);
            return subQuery.clone(rel);
        }

        private RexNode flattenComparison(RexBuilder rexBuilder, SqlOperator op, List<RexNode> exprs) {
            ArrayList flattenedExps = new ArrayList();
            RelStructuredTypeFlattener.this.flattenProjections(this, exprs, null, "", flattenedExps);
            int n = flattenedExps.size() / 2;
            boolean negate = false;
            if (op.getKind() == SqlKind.NOT_EQUALS) {
                negate = true;
                op = SqlStdOperatorTable.EQUALS;
            }
            if (n > 1 && op.getKind() != SqlKind.EQUALS) {
                throw Util.needToImplement("inequality comparison for row types");
            }
            RexNode conjunction = null;
            for (int i = 0; i < n; ++i) {
                RexNode comparison = rexBuilder.makeCall(op, (RexNode)((Pair)flattenedExps.get((int)i)).left, (RexNode)((Pair)flattenedExps.get((int)(i + n))).left);
                conjunction = conjunction == null ? comparison : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, conjunction, comparison);
            }
            if (negate) {
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, conjunction);
            }
            return conjunction;
        }
    }

    private class RewriteRelVisitor
    extends RelVisitor {
        private final ReflectiveVisitDispatcher<RelStructuredTypeFlattener, RelNode> dispatcher = ReflectUtil.createDispatcher(RelStructuredTypeFlattener.class, RelNode.class);

        private RewriteRelVisitor() {
        }

        @Override
        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            RelStructuredTypeFlattener.this.currentRel = p;
            String visitMethodName = "rewriteRel";
            boolean found = this.dispatcher.invokeVisitor(RelStructuredTypeFlattener.this, RelStructuredTypeFlattener.this.currentRel, "rewriteRel");
            RelStructuredTypeFlattener.this.currentRel = null;
            if (!found) {
                if (p.getInputs().size() == 0) {
                    RelStructuredTypeFlattener.this.rewriteGeneric(p);
                } else {
                    throw new AssertionError((Object)("no 'rewriteRel' method found for class " + p.getClass().getName()));
                }
            }
        }
    }

    public static interface SelfFlatteningRel
    extends RelNode {
        public void flattenRel(RelStructuredTypeFlattener var1);
    }
}

