/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.mutable.MutableSingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;

public class MutableAggregate
extends MutableSingleRel {
    public final ImmutableBitSet groupSet;
    public final ImmutableList<ImmutableBitSet> groupSets;
    public final List<AggregateCall> aggCalls;

    private MutableAggregate(MutableRel input, RelDataType rowType, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(MutableRelType.AGGREGATE, rowType, input);
        this.groupSet = groupSet;
        ImmutableList immutableList = this.groupSets = groupSets == null ? ImmutableList.of((Object)groupSet) : ImmutableList.copyOf(groupSets);
        assert (ImmutableBitSet.ORDERING.isStrictlyOrdered(this.groupSets)) : this.groupSets;
        for (ImmutableBitSet set : this.groupSets) {
            assert (groupSet.contains(set));
        }
        this.aggCalls = aggCalls;
    }

    public static MutableAggregate of(MutableRel input, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        RelDataType rowType = Aggregate.deriveRowType(input.cluster.getTypeFactory(), input.rowType, false, groupSet, groupSets, aggCalls);
        return new MutableAggregate(input, rowType, groupSet, (List<ImmutableBitSet>)groupSets, aggCalls);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MutableAggregate && this.groupSet.equals(((MutableAggregate)obj).groupSet) && this.groupSets.equals(((MutableAggregate)obj).groupSets) && this.aggCalls.equals(((MutableAggregate)obj).aggCalls) && this.input.equals(((MutableAggregate)obj).input);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.groupSet, this.groupSets, this.aggCalls);
    }

    @Override
    public StringBuilder digest(StringBuilder buf) {
        return buf.append("Aggregate(groupSet: ").append(this.groupSet).append(", groupSets: ").append(this.groupSets).append(", calls: ").append(this.aggCalls).append(")");
    }

    public Aggregate.Group getGroupType() {
        return Aggregate.Group.induce(this.groupSet, this.groupSets);
    }

    @Override
    public MutableRel clone() {
        return MutableAggregate.of(this.input.clone(), this.groupSet, this.groupSets, this.aggCalls);
    }
}

