/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.anyline.util.BasicUtil;

public class XssUtil {
    private static List<Pattern> patterns = new ArrayList<Pattern>();

    public static String strip(String value) {
        if (BasicUtil.isNotEmpty(value)) {
            Matcher matcher = null;
            for (Pattern pattern : patterns) {
                matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                value = matcher.replaceAll("");
            }
        }
        return value;
    }

    public static boolean check(String value) {
        if (BasicUtil.isNotEmpty(value)) {
            Matcher matcher = null;
            for (Pattern pattern : patterns) {
                matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                return false;
            }
        }
        return true;
    }

    static {
        ArrayList<Object[]> regexps = new ArrayList<Object[]>();
        regexps.add(new Object[]{"<(no)?script[^>]*>.*?</(no)?script>", 2});
        regexps.add(new Object[]{"eval\\((.*?)\\)", 42});
        regexps.add(new Object[]{"expression\\((.*?)\\)", 42});
        regexps.add(new Object[]{"(javascript:|vbscript:|view-source:)*", 2});
        regexps.add(new Object[]{"<(no)?iframe[^>]*>.*?</(no)?iframe>", 2});
        regexps.add(new Object[]{"<(no)?iframe[^>]*>", 2});
        regexps.add(new Object[]{"(window\\.location|window\\.|\\.location|document\\.cookie|document\\.|alert\\(.*?\\)|window\\.open\\()*", 42});
        regexps.add(new Object[]{"<+\\s*\\w*\\s*(oncontrolselect|oncopy|oncut|ondataavailable|ondatasetchanged|ondatasetcomplete|ondblclick|ondeactivate|ondrag|ondragend|ondragenter|ondragleave|ondragover|ondragstart|ondrop|onerror=|onerroupdate|onfilterchange|onfinish|onfocus|onfocusin|onfocusout|onhelp|onkeydown|onkeypress|onkeyup|onlayoutcomplete|onload|onlosecapture|onmousedown|onmouseenter|onmouseleave|onmousemove|onmousout|onmouseover|onmouseup|onmousewheel|onmove|onmoveend|onmovestart|onabort|onactivate|onafterprint|onafterupdate|onbefore|onbeforeactivate|onbeforecopy|onbeforecut|onbeforedeactivate|onbeforeeditocus|onbeforepaste|onbeforeprint|onbeforeunload|onbeforeupdate|onblur|onbounce|oncellchange|onchange|onclick|oncontextmenu|onpaste|onpropertychange|onreadystatechange|onreset|onresize|onresizend|onresizestart|onrowenter|onrowexit|onrowsdelete|onrowsinserted|onscroll|onselect|onselectionchange|onselectstart|onstart|onstop|onsubmit|onunload)+\\s*=+", 42});
        String regex = null;
        Integer flag = null;
        int arrLength = 0;
        for (Object[] arr : regexps) {
            arrLength = arr.length;
            for (int i = 0; i < arrLength; ++i) {
                regex = (String)arr[0];
                flag = (Integer)arr[1];
                patterns.add(Pattern.compile(regex, flag));
            }
        }
    }
}

