/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.NumberUtil;
import org.anyline.util.ZipUtil;
import org.anyline.util.encrypt.MD5Util;

public class FileUtil {
    private static final Log log = LogProxy.get(FileUtil.class);
    public static final int PATH_TYPE_JAR = 0;
    public static final List<String> httpFileExtend = new ArrayList<String>();
    public static final List<String> httpFileType = new ArrayList<String>();
    public static final Map<String, String> FILE_TYPE_MAP = new HashMap<String, String>();

    public static String merge(String ... paths) {
        String result = null;
        String separator = FileUtil.getFileSeparator();
        if (null != paths) {
            for (String path : paths) {
                if (BasicUtil.isEmpty((Object)path)) continue;
                if (null == result) {
                    result = path;
                    continue;
                }
                if (result.endsWith("/") || result.endsWith("\\")) {
                    if (path.startsWith("/") || path.startsWith("\\")) {
                        result = result + path.substring(1);
                        continue;
                    }
                    result = result + path;
                    continue;
                }
                result = path.startsWith("/") || path.startsWith("\\") ? result + path : result + separator + path;
            }
        }
        return result;
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static int getPathType(Class dest) {
        int type = -1;
        try {
            String path = dest.getResource("").getPath();
            type = path.contains(".jar!") ? 0 : 1;
        }
        catch (Exception e) {
            type = -1;
        }
        return type;
    }

    public static int getPathType(String path) {
        int type = -1;
        type = path.contains(".jar!") ? 0 : 1;
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer read(InputStream input, Charset encode) {
        StringBuffer buffer = new StringBuffer();
        if (null == input) {
            return buffer;
        }
        int BUFFER_SIZE = 81920;
        BufferedInputStream in = null;
        try {
            if (input.available() <= 0) {
                StringBuffer stringBuffer = buffer;
                return stringBuffer;
            }
            if (BUFFER_SIZE > input.available()) {
                BUFFER_SIZE = input.available();
            }
            in = new BufferedInputStream(input, BUFFER_SIZE);
            input.available();
            byte[] by = new byte[BUFFER_SIZE];
            int size = 0;
            while ((size = in.read(by)) != -1) {
                if (null == encode) {
                    buffer.append(new String(by, 0, size));
                    continue;
                }
                buffer.append(new String(by, 0, size, encode));
            }
        }
        catch (Exception ex) {
            log.error("read stream exception:", ex);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception e) {
                log.error("close stream exception:", e);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer read(InputStream input) {
        StringBuffer buffer = new StringBuffer();
        int BUFFER_SIZE = 8192;
        BufferedInputStream in = null;
        InputStreamReader reader = null;
        try {
            if (input.available() <= 0) {
                StringBuffer stringBuffer = buffer;
                return stringBuffer;
            }
            if (BUFFER_SIZE > input.available()) {
                BUFFER_SIZE = input.available();
            }
            in = new BufferedInputStream(input, BUFFER_SIZE);
            reader = new InputStreamReader(in);
            input.available();
            char[] by = new char[BUFFER_SIZE];
            int size = 0;
            while ((size = reader.read(by)) != -1) {
                buffer.append(new String(by, 0, size));
            }
        }
        catch (Exception ex) {
            log.error("read stream exception:", ex);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != input) {
                    input.close();
                }
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e) {
                log.error("close stream exception:", e);
            }
        }
        return buffer;
    }

    public static byte[] file2byte(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (Exception e) {
            log.error("file2byte exception:", e);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File byte2file(byte[] buf, File file) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            File dir = file.getParentFile();
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            log.error("byte2file exception:", e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error("byte2file exception:", e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error("byte2file exception:", e);
                }
            }
        }
        return file;
    }

    public static StringBuffer read(File file, Charset encode) {
        StringBuffer buffer = new StringBuffer();
        if (null != file && file.exists()) {
            try {
                buffer = file.getAbsolutePath().contains(".jar!") ? FileUtil.readJar(file.getAbsolutePath()) : FileUtil.read(new FileInputStream(file), encode);
            }
            catch (Exception e) {
                log.error("read file exception:", e);
            }
        }
        return buffer;
    }

    public static StringBuffer read(File file, String encode) {
        return FileUtil.read(file, Charset.forName(encode));
    }

    public static StringBuffer readJar(String path) throws IOException {
        InputStream in = FileUtil.class.getResourceAsStream(path);
        InputStreamReader f = new InputStreamReader(in);
        BufferedReader fb = new BufferedReader(f);
        StringBuffer builder = new StringBuffer();
        String s = "";
        while ((s = fb.readLine()) != null) {
            builder.append(s);
        }
        return builder;
    }

    public static StringBuffer read(File file) {
        StringBuffer buffer = new StringBuffer();
        if (null != file && file.exists()) {
            try {
                buffer = FileUtil.read(new FileInputStream(file));
            }
            catch (Exception e) {
                log.error("read file exception:", e);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String content, File file, Charset encode, boolean append) {
        if (null == file) {
            return;
        }
        File dir = file.getParentFile();
        if (null != dir && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(file, append);
            osw = new OutputStreamWriter((OutputStream)fos, encode);
            if (append) {
                osw.append(content);
            } else {
                osw.write(content);
            }
            osw.flush();
        }
        catch (Exception e) {
            log.error("write file exception:", e);
        }
        finally {
            try {
                assert (osw != null);
                osw.close();
                fos.close();
            }
            catch (Exception e) {
                log.error("close stream exception:", e);
            }
        }
    }

    public static void write(String content, File file, String encode, boolean append) {
        FileUtil.write(content, file, Charset.forName(encode), append);
    }

    public static void write(String content, File file, Charset encode) {
        FileUtil.write(content, file, encode, false);
    }

    public static void write(String content, File file, String encode) {
        FileUtil.write(content, file, Charset.forName(encode), false);
    }

    public static void write(String content, File file, boolean append) {
        FileUtil.write(content, file, "UTF-8", append);
    }

    public static void write(String content, File file) {
        FileUtil.write(content, file, "UTF-8", false);
    }

    public static boolean write(InputStream is, File file) {
        if (null == file || null == is) {
            return false;
        }
        try {
            if (!file.exists()) {
                File dir = file.getParentFile();
                if (null != dir && !dir.exists()) {
                    dir.mkdirs();
                }
                file.createNewFile();
            }
            FileOutputStream os = new FileOutputStream(file);
            return FileUtil.write(is, os, true);
        }
        catch (Exception e) {
            log.error("write file exception:", e);
            return false;
        }
    }

    public static boolean write(InputStream is, OutputStream os) {
        return FileUtil.write(is, os, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(InputStream is, OutputStream os, boolean close) {
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] arr = new byte[1024];
        try {
            int len;
            while ((len = bis.read(arr)) != -1) {
                os.write(arr, 0, len);
                os.flush();
            }
        }
        catch (Exception e) {
            log.error("write stream exception:", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (close) {
                try {
                    os.close();
                }
                catch (Exception ignored) {}
                try {
                    is.close();
                }
                catch (Exception gignored) {}
            }
        }
        return true;
    }

    public static boolean create(String dir, String name, boolean over) {
        String filePath = FileUtil.merge(dir, name);
        return FileUtil.create(filePath, over);
    }

    public static boolean create(String file, boolean over) {
        return FileUtil.create(new File(file), over);
    }

    public static boolean create(File file, boolean over) {
        if (null == file) {
            return false;
        }
        try {
            File dir = file.getParentFile();
            if (null != dir && !dir.exists()) {
                dir.mkdirs();
            }
            if (file.exists()) {
                if (over) {
                    file.delete();
                } else {
                    return true;
                }
            }
            file.createNewFile();
        }
        catch (Exception e) {
            log.error("create file exception:", e);
        }
        return true;
    }

    public static File createTempFile(File file) throws Exception {
        if (!file.exists()) {
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728:" + file.getAbsolutePath());
        }
        File tempFile = File.createTempFile(file.getName(), null);
        boolean renameOk = file.renameTo(tempFile);
        if (!renameOk) {
            tempFile = new File(file.getParent(), "tmp_" + System.currentTimeMillis() + file.getName());
            renameOk = file.renameTo(tempFile);
        }
        if (!renameOk) {
            FileUtil.copy(file, tempFile);
        }
        if (!tempFile.exists()) {
            throw new Exception("\u91cd\u547d\u540d\u5931\u8d25 " + file.getAbsolutePath() + " > " + tempFile.getAbsolutePath());
        }
        return tempFile;
    }

    public static String fetchPathByUrl(String url) {
        int to = url.indexOf("?");
        if (to != -1) {
            url = url.substring(0, to);
        }
        return url;
    }

    public static String fetchDirByUrl(String url) {
        String dir = null;
        if (url.endsWith("/")) {
            dir = url;
        } else if (FileUtil.isHttpFile(url)) {
            int to = url.lastIndexOf("/");
            dir = url.substring(0, to);
        } else {
            dir = url;
        }
        return dir;
    }

    private static boolean isHttpFile(String path) {
        if (path.endsWith("/")) {
            return false;
        }
        String head = "http://";
        int fr = head.length();
        int l1 = path.lastIndexOf("/");
        int l2 = path.lastIndexOf(".");
        if (l1 == -1) {
            return false;
        }
        return l2 > l1 && l2 > fr;
    }

    public static String getHostUrl(String url) {
        int idx = (url = url.replaceAll("http://", "")).indexOf("/");
        if (idx != -1) {
            url = url.substring(0, idx);
        }
        url = "http://" + url;
        return url;
    }

    public static String getSimpleFileName(File file) {
        String name = null;
        if (null == file) {
            return null;
        }
        name = file.getName();
        int idx = name.lastIndexOf(".");
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        return name;
    }

    public static String getSimpleFileName(String file) {
        return FileUtil.getSimpleFileName(new File(file));
    }

    public static String getFileName(String file) {
        return FileUtil.getFileName(new File(file));
    }

    public static String getFileName(File file) {
        if (null != file) {
            return file.getName();
        }
        return null;
    }

    public static String getSuffixFileName(File file) {
        String name = null;
        if (null == file) {
            return null;
        }
        name = file.getName();
        int idx = name.lastIndexOf(".");
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static String getSuffixFileName(String file) {
        return FileUtil.getSuffixFileName(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        boolean result = true;
        if (src.isDirectory()) {
            if (!dest.exists()) {
                result = dest.mkdirs();
            }
            String[] files = src.list();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.copy(new File(src, files[i]), new File(dest, files[i]));
            }
        } else if (!src.exists()) {
            result = false;
        } else {
            File dir = dest.getParentFile();
            if (null != dir && !dir.exists()) {
                dir.mkdirs();
            }
            InputStream in = null;
            OutputStream out = null;
            try {
                int len;
                if (!dest.isDirectory()) {
                    File dirs = dest.getParentFile();
                    if (null != dir && !dirs.exists()) {
                        dirs.mkdirs();
                    }
                } else {
                    dest = new File(dest, src.getName());
                }
                dest.createNewFile();
                in = new FileInputStream(src);
                out = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage());
                    }
                }
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage());
                    }
                }
            }
        }
        return result;
    }

    public static List<File> getAllChildrenFile(File dir, int depth, String ... suffix) {
        ArrayList<File> list = new ArrayList<File>();
        if (dir.isFile()) {
            if (FileUtil.filterByType(dir, suffix)) {
                list.add(dir);
            }
            return list;
        }
        File[] children = dir.listFiles();
        if (null != children) {
            for (File child : children) {
                if (child.isFile()) {
                    if (!FileUtil.filterByType(child, suffix)) continue;
                    list.add(child);
                    continue;
                }
                if (depth == 0) continue;
                List<File> tmpList = FileUtil.getAllChildrenFile(child, depth - 1, suffix);
                list.addAll(tmpList);
            }
        }
        return list;
    }

    public static List<File> getAllChildrenFile(File dir, String ... suffix) {
        return FileUtil.getAllChildrenFile(dir, -1, suffix);
    }

    public static List<File> getAllChildrenDirectory(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        if (dir.isFile()) {
            return list;
        }
        File[] children = dir.listFiles();
        if (null != children) {
            for (File child : children) {
                if (child.isHidden() || !child.isDirectory()) continue;
                if (null == child.listFiles() || child.listFiles().length == 0) {
                    list.add(child);
                    continue;
                }
                list.addAll(FileUtil.getAllChildrenDirectory(child));
            }
        }
        return list;
    }

    public static List<File> getChildrenFile(File dir, String ... types) {
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (null != files) {
            for (File file : files) {
                if (!file.isFile() || !FileUtil.filterByType(file, types)) continue;
                list.add(file);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getZipAllChildrenFile(File zip, String ... types) {
        ArrayList<File> list = new ArrayList<File>();
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new FileInputStream(zip));
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                String path = zip.getAbsolutePath() + "!/" + entry.getName();
                File file = new File(path);
                if (!FileUtil.filterByType(file, types)) continue;
                list.add(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static boolean filterByType(File file, String ... types) {
        if (null == file) {
            return false;
        }
        if (null == types || types.length == 0) {
            return true;
        }
        for (String type : types) {
            String fileName = file.getAbsolutePath().toUpperCase();
            if (!fileName.endsWith(type = type.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static String parseSubName(String fileName) {
        String result = null;
        if (null == fileName) {
            return null;
        }
        int idx = fileName.lastIndexOf(".");
        if (idx > 0) {
            result = fileName.substring(idx + 1);
        }
        return result;
    }

    public static boolean exists(File file) {
        if (null == file) {
            return false;
        }
        return file.exists();
    }

    public static boolean exists(String file) {
        return FileUtil.exists(new File(file));
    }

    public static boolean isFile(File file) {
        if (null == file) {
            return false;
        }
        return file.isFile();
    }

    public static boolean isFile(String file) {
        return FileUtil.isFile(new File(file));
    }

    public static String parseSubName(File file) {
        String filetype = null;
        byte[] b = new byte[50];
        try {
            FileInputStream is = new FileInputStream(file);
            ((InputStream)is).read(b);
            filetype = FileUtil.getFileType(b);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filetype;
    }

    public static String getFileType(byte[] b) {
        String hex = NumberUtil.byte2hex(b);
        for (Map.Entry<String, String> entry : FILE_TYPE_MAP.entrySet()) {
            String fileTypeHexValue = entry.getValue();
            if (!hex.toUpperCase().startsWith(fileTypeHexValue)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean delete(File file) {
        if (null == file) {
            return false;
        }
        boolean result = true;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (null != children) {
                for (File child : children) {
                    FileUtil.delete(child);
                }
            }
            result = file.delete();
            log.info("[\u76ee\u5f55\u5220\u9664][result:" + result + "][file:" + file.getAbsolutePath() + "]");
        } else {
            result = file.delete();
            log.info("[\u6587\u4ef6\u5220\u9664][result:" + result + "][file:" + file.getAbsolutePath() + "]");
        }
        return result;
    }

    public static int lines(File file, String ... subbfixs) {
        int size = 0;
        if (null == file || !file.exists()) {
            return size;
        }
        if (file.isDirectory()) {
            List<File> files = FileUtil.getAllChildrenFile(file, subbfixs);
            for (File item : files) {
                size += FileUtil.lines(item, new String[0]);
            }
        }
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            lineNumberReader.skip(file.length());
            size += lineNumberReader.getLineNumber();
            lineNumberReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public static boolean zip(File zip, File ... srcs) {
        ArrayList<File> files = new ArrayList<File>();
        for (File src : srcs) {
            files.add(src);
        }
        return FileUtil.zip(zip, files);
    }

    public static boolean zip(File zip, List<File> srcs) {
        return ZipUtil.zip(srcs, zip);
    }

    public static String md5(File file) {
        return MD5Util.crypto(file);
    }

    public static Map<String, String> md5(File file, boolean recursion) {
        return MD5Util.crypto(file, recursion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(InputStream is, File file) {
        if (BasicUtil.isEmpty((Object)file)) {
            return false;
        }
        long fr = System.currentTimeMillis();
        File dir = file.getParentFile();
        if (null != dir && !dir.exists()) {
            dir.mkdirs();
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream(new FileOutputStream(file));
            int len = -1;
            while ((len = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(len);
                ((BufferedOutputStream)bos).flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != bos) {
                    bos.close();
                }
            }
            catch (Exception ignored) {}
            try {
                if (null != bis) {
                    bis.close();
                }
            }
            catch (Exception ignored) {}
        }
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.info("[save file][file:" + file.getAbsolutePath() + "][\u8017\u65f6:" + (System.currentTimeMillis() - fr) + "]");
        }
        return true;
    }

    public static boolean save(InputStream is, String path) {
        return FileUtil.save(is, new File(path));
    }

    public static String progress(long total, long finish) {
        String title = "";
        double rate = (double)finish * 100.0 / (double)total;
        String rateTitle = NumberUtil.format(rate, "0.00");
        if (finish >= total) {
            rateTitle = "100";
        }
        title = FileUtil.length(finish) + "/" + FileUtil.length(total) + "(" + rateTitle + "%)";
        return title;
    }

    public static String length(long b) {
        String result = "";
        if (b < 1024L) {
            result = b + "byte";
        } else if (b < 0x100000L) {
            result = NumberUtil.format((double)b / 1024.0, "0.00") + "kb";
        } else if (b < 0x40000000L) {
            result = NumberUtil.format((double)b / 1024.0 / 1024.0, "0.00") + "mb";
        } else if (b < 0x10000000000L) {
            result = NumberUtil.format((double)b / 1024.0 / 1024.0 / 1024.0, "0.00") + "gb";
        } else if (b < 0x4000000000000L) {
            result = NumberUtil.format((double)b / 1024.0 / 1024.0 / 1024.0 / 1024.0, "0.00") + "tb";
        } else if (b < 0x1000000000000000L) {
            result = NumberUtil.format((double)b / 1024.0 / 1024.0 / 1024.0 / 1024.0 / 1024.0, "0.00") + "pb";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(File dest, List<File> items) {
        FileOutputStream os = null;
        FileInputStream is = null;
        try {
            File dir = dest.getParentFile();
            if (null != dir && !dir.exists()) {
                dir.mkdirs();
            }
            os = new FileOutputStream(dest);
            byte[] bytes = new byte[1024];
            int length = 0;
            for (File item : items) {
                if (!item.exists()) continue;
                long fr = System.currentTimeMillis();
                is = new FileInputStream(item);
                while ((length = is.read(bytes)) != -1) {
                    os.write(bytes, 0, length);
                }
                log.info("[\u5408\u5e76\u6587\u4ef6][\u8017\u65f6:" + DateUtil.conversion(System.currentTimeMillis() - fr) + "][file:" + dest.getAbsolutePath() + "][item:" + item.getAbsolutePath() + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {}
        }
        try {
            is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(File dest, File dir) {
        OutputStream os = null;
        FileInputStream is = null;
        try {
            File root = dest.getParentFile();
            if (null != root && !root.exists()) {
                root.mkdirs();
            }
            os = new FileOutputStream(dest);
            byte[] bytes = new byte[1024];
            int length = 0;
            List<File> items = FileUtil.getAllChildrenFile(dir, new String[0]);
            for (File item : items) {
                if (!item.exists()) continue;
                long fr = System.currentTimeMillis();
                is = new FileInputStream(item);
                while ((length = is.read(bytes)) != -1) {
                    ((FileOutputStream)os).write(bytes, 0, length);
                }
                log.info("[\u5408\u5e76\u6587\u4ef6][\u8017\u65f6:" + DateUtil.conversion(System.currentTimeMillis() - fr) + "][file:" + dest.getAbsolutePath() + "][item:" + item.getAbsolutePath() + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.flush();
                ((FileOutputStream)os).close();
            }
            catch (Exception e) {}
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        try {
            is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void replace(File file, Charset encode, String fr, String to) {
        if (file.exists() && BasicUtil.isNotEmpty(fr) && null != to) {
            String content = FileUtil.read(file, encode).toString().replace(fr, to);
            FileUtil.write(content, file, encode);
        }
    }

    public static void replace(File file, String fr, String to) {
        if (file.exists() && BasicUtil.isNotEmpty(fr) && null != to) {
            String content = FileUtil.read(file).toString().replace(fr, to);
            FileUtil.write(content, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void split(File file, int count) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel input = null;
        AbstractInterruptibleChannel out = null;
        try {
            fis = new FileInputStream(file);
            input = fis.getChannel();
            String fileName = FileUtil.getSimpleFileName(file);
            String subName = FileUtil.getSuffixFileName(file);
            if (BasicUtil.isNotEmpty(subName)) {
                subName = "." + subName;
            }
            long fileSize = ((FileChannel)input).size();
            long average = fileSize / (long)count;
            long bufferSize = 1024L;
            ByteBuffer byteBuffer = ByteBuffer.allocate(Integer.valueOf(bufferSize + ""));
            long startPosition = 0L;
            long endPosition = average < bufferSize ? 0L : average - bufferSize;
            for (int i = 0; i < count; ++i) {
                long fr;
                block40: {
                    fr = System.currentTimeMillis();
                    if (i + 1 != count) {
                        int read = ((FileChannel)input).read(byteBuffer, endPosition);
                        while (read != -1) {
                            byteBuffer.flip();
                            byte[] array = byteBuffer.array();
                            for (int j = 0; j < array.length; ++j) {
                                byte b = array[j];
                                if (b != 10 && b != 13) continue;
                                endPosition += (long)j;
                                break block40;
                            }
                            byteBuffer.clear();
                            read = ((FileChannel)input).read(byteBuffer, endPosition += bufferSize);
                        }
                    } else {
                        endPosition = fileSize;
                    }
                }
                File item = new File(file.getParent(), fileName + "_" + (i + 1) + subName);
                try {
                    fos = new FileOutputStream(item);
                    out = fos.getChannel();
                    ((FileChannel)input).transferTo(startPosition, endPosition - startPosition, (WritableByteChannel)((Object)out));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                startPosition = endPosition + 1L;
                endPosition += average;
                log.info("[\u6587\u4ef6\u5206\u5272][" + (i + 1) + "/" + count + "][\u8017\u65f6:" + DateUtil.conversion(System.currentTimeMillis() - fr) + "][src:" + file.getAbsolutePath() + "][item:" + item.getAbsolutePath() + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        FILE_TYPE_MAP.put("jpg", "FFD8FF");
        FILE_TYPE_MAP.put("png", "89504E47");
        FILE_TYPE_MAP.put("gif", "47494638");
        FILE_TYPE_MAP.put("tif", "49492A00");
        FILE_TYPE_MAP.put("bmp", "424D");
        FILE_TYPE_MAP.put("dwg", "41433130");
        FILE_TYPE_MAP.put("html", "68746D6C3E");
        FILE_TYPE_MAP.put("rtf", "7B5C727466");
        FILE_TYPE_MAP.put("xml", "3C3F786D6C");
        FILE_TYPE_MAP.put("zip", "504B0304");
        FILE_TYPE_MAP.put("rar", "52617221");
        FILE_TYPE_MAP.put("psd", "38425053");
        FILE_TYPE_MAP.put("eml", "44656C69766572792D646174653A");
        FILE_TYPE_MAP.put("dbx", "CFAD12FEC5FD746F");
        FILE_TYPE_MAP.put("pst", "2142444E");
        FILE_TYPE_MAP.put("xls", "D0CF11E0");
        FILE_TYPE_MAP.put("xlsx", "504B0304");
        FILE_TYPE_MAP.put("doc", "D0CF11E0");
        FILE_TYPE_MAP.put("docx", "504B0304");
        FILE_TYPE_MAP.put("ppt", "D0CF11E0");
        FILE_TYPE_MAP.put("pptx", "504B0304");
        FILE_TYPE_MAP.put("mdb", "5374616E64617264204A");
        FILE_TYPE_MAP.put("wpd", "FF575043");
        FILE_TYPE_MAP.put("eps", "252150532D41646F6265");
        FILE_TYPE_MAP.put("ps", "252150532D41646F6265");
        FILE_TYPE_MAP.put("pdf", "255044462D312E");
        FILE_TYPE_MAP.put("qdf", "AC9EBD8F");
        FILE_TYPE_MAP.put("pwl", "E3828596");
        FILE_TYPE_MAP.put("wav", "57415645");
        FILE_TYPE_MAP.put("avi", "41564920");
        FILE_TYPE_MAP.put("ram", "2E7261FD");
        FILE_TYPE_MAP.put("rm", "2E524D46");
        FILE_TYPE_MAP.put("mpg", "000001BA");
        FILE_TYPE_MAP.put("mov", "6D6F6F76");
        FILE_TYPE_MAP.put("asf", "3026B2758E66CF11");
        FILE_TYPE_MAP.put("mid", "4D546864");
        httpFileExtend.add("ai");
        httpFileType.add("application/postscript");
        httpFileExtend.add("aif");
        httpFileType.add("audio/x-aiff");
        httpFileExtend.add("aifc");
        httpFileType.add("audio/x-aiff");
        httpFileExtend.add("aiff");
        httpFileType.add("audio/x-aiff");
        httpFileExtend.add("asc");
        httpFileType.add("text/plain");
        httpFileExtend.add("au");
        httpFileType.add("audio/basic");
        httpFileExtend.add("avi");
        httpFileType.add("video/x-msvideo");
        httpFileExtend.add("bcpio");
        httpFileType.add("application/x-bcpio");
        httpFileExtend.add("bin");
        httpFileType.add("application/octet-stream");
        httpFileExtend.add("bmp");
        httpFileType.add("image/bmp");
        httpFileExtend.add("cdf");
        httpFileType.add("application/x-netcdf");
        httpFileExtend.add("class");
        httpFileType.add("application/octet-stream");
        httpFileExtend.add("cpio");
        httpFileType.add("application/x-cpio");
        httpFileExtend.add("cpt");
        httpFileType.add("application/mac-compactpro");
        httpFileExtend.add("csh");
        httpFileType.add("application/x-csh");
        httpFileExtend.add("css");
        httpFileType.add("text/css");
        httpFileExtend.add("dcr");
        httpFileType.add("application/x-director");
        httpFileExtend.add("dir");
        httpFileType.add("application/x-director");
        httpFileExtend.add("djv");
        httpFileType.add("image/vnd.djvu");
        httpFileExtend.add("djvu");
        httpFileType.add("image/vnd.djvu");
        httpFileExtend.add("dll");
        httpFileType.add("application/octet-stream");
        httpFileExtend.add("dms");
        httpFileType.add("application/octet-stream");
        httpFileExtend.add("doc");
        httpFileType.add("application/msword");
        httpFileExtend.add("docx");
        httpFileType.add("aapplication/vnd.openxmlformats-officedocument.wordprocessingml.document");
        httpFileExtend.add("dvi");
        httpFileType.add("application/x-dvi");
        httpFileExtend.add("dxr");
        httpFileType.add("application/x-director");
        httpFileExtend.add("eps");
        httpFileType.add("application/postscript");
        httpFileExtend.add("etx");
        httpFileType.add("text/x-setext");
        httpFileExtend.add("exe");
        httpFileType.add("application/octet-stream");
        httpFileExtend.add("ez");
        httpFileType.add("application/andrew-inset");
        httpFileExtend.add("gif");
        httpFileType.add("image/gif");
        httpFileExtend.add("gtar");
        httpFileType.add("application/x-gtar");
        httpFileExtend.add("hdf");
        httpFileType.add("application/x-hdf");
        httpFileExtend.add("hqx");
        httpFileType.add("application/mac-binhex40");
        httpFileExtend.add("htm");
        httpFileType.add("text/html");
        httpFileExtend.add("html");
        httpFileType.add("text/html");
        httpFileExtend.add("ice");
        httpFileType.add("x-conference/x-cooltalk");
        httpFileExtend.add("ief");
        httpFileType.add("image/ief");
        httpFileExtend.add("iges");
        httpFileType.add("model/iges");
        httpFileExtend.add("igs");
        httpFileType.add("model/iges");
        httpFileExtend.add("jpe");
        httpFileType.add("image/jpeg");
        httpFileExtend.add("jpeg");
        httpFileType.add("image/jpeg");
        httpFileExtend.add("jpg");
        httpFileType.add("image/jpeg");
        httpFileExtend.add("js");
        httpFileType.add("application/x-javascript");
        httpFileExtend.add("kar");
        httpFileType.add("audio/midi");
        httpFileExtend.add("latex");
        httpFileType.add("application/x-latex");
        httpFileExtend.add("lha");
        httpFileType.add("application/octet-stream");
        httpFileExtend.add("lzh");
        httpFileType.add("application/octet-stream");
        httpFileExtend.add("m3u");
        httpFileType.add("audio/x-mpegurl");
        httpFileExtend.add("man");
        httpFileType.add("application/x-troff-man");
        httpFileExtend.add("me");
        httpFileType.add("application/x-troff-me");
        httpFileExtend.add("mesh");
        httpFileType.add("model/mesh");
        httpFileExtend.add("mid");
        httpFileType.add("audio/midi");
        httpFileExtend.add("midi");
        httpFileType.add("audio/midi");
        httpFileExtend.add("mif");
        httpFileType.add("application/vnd.mif");
        httpFileExtend.add("mov");
        httpFileType.add("video/quicktime");
        httpFileExtend.add("movie");
        httpFileType.add("video/x-sgi-movie");
        httpFileExtend.add("mp2");
        httpFileType.add("audio/mpeg");
        httpFileExtend.add("mp3");
        httpFileType.add("audio/mpeg");
        httpFileExtend.add("mpe");
        httpFileType.add("video/mpeg");
        httpFileExtend.add("mpeg");
        httpFileType.add("video/mpeg");
        httpFileExtend.add("mpg");
        httpFileType.add("video/mpeg");
        httpFileExtend.add("mpga");
        httpFileType.add("audio/mpeg");
        httpFileExtend.add("ms");
        httpFileType.add("application/x-troff-ms");
        httpFileExtend.add("msh");
        httpFileType.add("model/mesh");
        httpFileExtend.add("mxu");
        httpFileType.add("video/vnd.mpegurl");
        httpFileExtend.add("nc");
        httpFileType.add("application/x-netcdf");
        httpFileExtend.add("oda");
        httpFileType.add("application/oda");
        httpFileExtend.add("pbm");
        httpFileType.add("image/x-portable-bitmap");
        httpFileExtend.add("pdb");
        httpFileType.add("chemical/x-pdb");
        httpFileExtend.add("pdf");
        httpFileType.add("application/pdf");
        httpFileExtend.add("pgm");
        httpFileType.add("image/x-portable-graymap");
        httpFileExtend.add("pgn");
        httpFileType.add("application/x-chess-pgn");
        httpFileExtend.add("png");
        httpFileType.add("image/png");
        httpFileExtend.add("pnm");
        httpFileType.add("image/x-portable-anymap");
        httpFileExtend.add("ppm");
        httpFileType.add("image/x-portable-pixmap");
        httpFileExtend.add("ppt");
        httpFileType.add("application/vnd.ms-powerpoint");
        httpFileExtend.add("pptx");
        httpFileType.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        httpFileExtend.add("ps");
        httpFileType.add("application/postscript");
        httpFileExtend.add("qt");
        httpFileType.add("video/quicktime");
        httpFileExtend.add("ra");
        httpFileType.add("audio/x-realaudio");
        httpFileExtend.add("ram");
        httpFileType.add("audio/x-pn-realaudio");
        httpFileExtend.add("ras");
        httpFileType.add("image/x-cmu-raster");
        httpFileExtend.add("rgb");
        httpFileType.add("image/x-rgb");
        httpFileExtend.add("rm");
        httpFileType.add("audio/x-pn-realaudio");
        httpFileExtend.add("roff");
        httpFileType.add("application/x-troff");
        httpFileExtend.add("rpm");
        httpFileType.add("audio/x-pn-realaudio-plugin");
        httpFileExtend.add("rtf");
        httpFileType.add("text/rtf");
        httpFileExtend.add("rtx");
        httpFileType.add("text/richtext");
        httpFileExtend.add("sgm");
        httpFileType.add("text/sgml");
        httpFileExtend.add("sgml");
        httpFileType.add("text/sgml");
        httpFileExtend.add("sh");
        httpFileType.add("application/x-sh");
        httpFileExtend.add("shar");
        httpFileType.add("application/x-shar");
        httpFileExtend.add("silo");
        httpFileType.add("model/mesh");
        httpFileExtend.add("sit");
        httpFileType.add("application/x-stuffit");
        httpFileExtend.add("skd");
        httpFileType.add("application/x-koan");
        httpFileExtend.add("skm");
        httpFileType.add("application/x-koan");
        httpFileExtend.add("skp");
        httpFileType.add("application/x-koan");
        httpFileExtend.add("skt");
        httpFileType.add("application/x-koan");
        httpFileExtend.add("smi");
        httpFileType.add("application/smil");
        httpFileExtend.add("smil");
        httpFileType.add("application/smil");
        httpFileExtend.add("snd");
        httpFileType.add("audio/basic");
        httpFileExtend.add("so");
        httpFileType.add("application/octet-stream");
        httpFileExtend.add("spl");
        httpFileType.add("application/x-futuresplash");
        httpFileExtend.add("src");
        httpFileType.add("application/x-wais-source");
        httpFileExtend.add("sv4cpio");
        httpFileType.add("application/x-sv4cpio");
        httpFileExtend.add("sv4crc");
        httpFileType.add("application/x-sv4crc");
        httpFileExtend.add("swf");
        httpFileType.add("application/x-shockwave-flash");
        httpFileExtend.add("t");
        httpFileType.add("application/x-troff");
        httpFileExtend.add("tar");
        httpFileType.add("application/x-tar");
        httpFileExtend.add("tcl");
        httpFileType.add("application/x-tcl");
        httpFileExtend.add("tex");
        httpFileType.add("application/x-tex");
        httpFileExtend.add("texi");
        httpFileType.add("application/x-texinfo");
        httpFileExtend.add("texinfo");
        httpFileType.add("application/x-texinfo");
        httpFileExtend.add("tif");
        httpFileType.add("image/tiff");
        httpFileExtend.add("tiff");
        httpFileType.add("image/tiff");
        httpFileExtend.add("tr");
        httpFileType.add("application/x-troff");
        httpFileExtend.add("tsv");
        httpFileType.add("text/tab-separated-values");
        httpFileExtend.add("txt");
        httpFileType.add("text/plain");
        httpFileExtend.add("ustar");
        httpFileType.add("application/x-ustar");
        httpFileExtend.add("vcd");
        httpFileType.add("application/x-cdlink");
        httpFileExtend.add("vrml");
        httpFileType.add("model/vrml");
        httpFileExtend.add("wav");
        httpFileType.add("audio/x-wav");
        httpFileExtend.add("wbmp");
        httpFileType.add("image/vnd.wap.wbmp");
        httpFileExtend.add("wbxml");
        httpFileType.add("application/vnd.wap.wbxml");
        httpFileExtend.add("wml");
        httpFileType.add("text/vnd.wap.wml");
        httpFileExtend.add("wmlc");
        httpFileType.add("application/vnd.wap.wmlc");
        httpFileExtend.add("wmls");
        httpFileType.add("text/vnd.wap.wmlscript");
        httpFileExtend.add("wmlsc");
        httpFileType.add("application/vnd.wap.wmlscriptc");
        httpFileExtend.add("wrl");
        httpFileType.add("model/vrml");
        httpFileExtend.add("xbm");
        httpFileType.add("image/x-xbitmap");
        httpFileExtend.add("xht");
        httpFileType.add("application/xhtml+xml");
        httpFileExtend.add("xhtml");
        httpFileType.add("application/xhtml+xml");
        httpFileExtend.add("xls");
        httpFileType.add("application/vnd.ms-excel");
        httpFileExtend.add("xlsx");
        httpFileType.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet\n");
        httpFileExtend.add("xml");
        httpFileType.add("text/xml");
        httpFileExtend.add("xpm");
        httpFileType.add("image/x-xpixmap");
        httpFileExtend.add("xsl");
        httpFileType.add("text/xml");
        httpFileExtend.add("xwd");
        httpFileType.add("image/x-xwindowdump");
        httpFileExtend.add("xyz");
        httpFileType.add("chemical/x-xyz");
        httpFileExtend.add("zip");
        httpFileType.add("application/zip");
    }
}

