/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.entity.AbstractGroup;
import org.anyline.entity.DataRow;
import org.anyline.entity.Group;
import org.anyline.entity.GroupStore;
import org.anyline.entity.OriginRow;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;

public class DefaultGroupStore
implements GroupStore,
Serializable {
    private static final long serialVersionUID = 1257282062069295247L;
    private LinkedHashMap<String, Group> groups = new LinkedHashMap();

    @Override
    public LinkedHashMap<String, Group> gets() {
        return this.groups;
    }

    @Override
    public void add(Group group) {
        if (null == group) {
            return;
        }
        this.groups.put(group.getColumn().toUpperCase(), group);
    }

    @Override
    public void add(String str) {
        if (BasicUtil.isEmpty((Object)str)) {
            return;
        }
        if (str.toUpperCase().contains("GROUP BY")) {
            str = str.replaceAll("(?i)group\\s+by", "").trim();
        }
        if (str.contains(")") || str.contains("'")) {
            this.add(new AbstractGroup(str));
        } else {
            String[] tmps;
            for (String tmp : tmps = str.split(",")) {
                this.add(new AbstractGroup(tmp));
            }
        }
    }

    @Override
    public Group get(String group) {
        if (null == group) {
            return null;
        }
        return this.groups.get(group.toUpperCase());
    }

    @Override
    public void clear() {
        this.groups.clear();
    }

    @Override
    public String getRunText(String delimiter) {
        StringBuilder builder = new StringBuilder();
        if (null != this.groups && !this.groups.isEmpty()) {
            builder.append("GROUP BY ");
            boolean first = true;
            for (Group group : this.groups.values()) {
                if (null == group) continue;
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                SQLUtil.delimiter(builder, group.getColumn(), delimiter);
            }
        }
        return builder.toString();
    }

    @Override
    public boolean isEmpty() {
        if (null != this.groups) {
            return this.groups.isEmpty();
        }
        return true;
    }

    @Override
    public DataRow map(boolean empty) {
        OriginRow row = new OriginRow();
        return row;
    }

    @Override
    public List<DataRow> list(boolean empty) {
        ArrayList<DataRow> list = new ArrayList<DataRow>();
        for (Group group : this.groups.values()) {
            list.add(group.map(empty));
        }
        return list;
    }

    @Override
    public GroupStore clone() {
        DefaultGroupStore clone = null;
        try {
            clone = (DefaultGroupStore)super.clone();
        }
        catch (Exception e) {
            clone = new DefaultGroupStore();
        }
        if (null != this.groups) {
            for (Group group : this.groups.values()) {
                clone.add(group.clone());
            }
        }
        return clone;
    }
}

