/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.util.LinkedHashMap;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.ClassQuery;
import org.anarres.jdiagnostics.MethodExistsCallQuery;
import org.anarres.jdiagnostics.Result;

public class ThrowableQuery
extends AbstractQuery {
    private final Throwable throwable;

    public ThrowableQuery(Throwable throwable) {
        this.throwable = throwable;
    }

    public String getName() {
        return "throwable";
    }

    protected Result newResult() {
        return new Result(new LinkedHashMap<String, Object>());
    }

    public void call(Result result, String prefix) {
        Object suppressed;
        if (this.throwable == null) {
            result.put("message", "<null throwable>");
            return;
        }
        new ClassQuery(this.throwable.getClass()).call(result, prefix + "throwable/");
        result.put("message", this.throwable.getMessage());
        int i = 0;
        for (StackTraceElement e : this.throwable.getStackTrace()) {
            result.put(prefix + "frame" + i + "/element", e);
            result.put(prefix + "frame" + i + "/class", new ClassExistsQuery(e.getClassName()).call());
            ++i;
        }
        Object cause = new MethodExistsCallQuery(this.throwable, Throwable.class, "getCause").invoke(result, prefix + "cause/");
        if (cause instanceof Throwable) {
            Throwable t = (Throwable)cause;
            result.put(prefix + "cause", new ThrowableQuery(t).call());
        }
        if ((suppressed = new MethodExistsCallQuery(this.throwable, Throwable.class, "getSuppressed").invoke(result, prefix + "suppressed/")) instanceof Throwable[]) {
            int j = 0;
            for (Throwable t : (Throwable[])suppressed) {
                result.put(prefix + "suppressed" + j, new ThrowableQuery(t).call());
                ++j;
            }
        }
    }
}

