/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;

public final class UnsafeBufferPosition
implements Position {
    private final int counterId;
    private final int offset;
    private final UnsafeBuffer buffer;
    private final CountersManager countersManager;

    public UnsafeBufferPosition(UnsafeBuffer buffer, int counterId) {
        this(buffer, counterId, null);
    }

    public UnsafeBufferPosition(UnsafeBuffer buffer, int counterId, CountersManager countersManager) {
        this.buffer = buffer;
        this.counterId = counterId;
        this.countersManager = countersManager;
        this.offset = CountersManager.counterOffset(counterId);
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public long get() {
        return this.buffer.getLong(this.offset);
    }

    @Override
    public long getVolatile() {
        return this.buffer.getLongVolatile(this.offset);
    }

    @Override
    public void set(long value) {
        this.buffer.putLong(this.offset, value);
    }

    @Override
    public void setOrdered(long value) {
        this.buffer.putLongOrdered(this.offset, value);
    }

    @Override
    public boolean proposeMax(long proposedValue) {
        UnsafeBuffer buffer = this.buffer;
        int offset = this.offset;
        boolean updated = false;
        if (buffer.getLong(offset) < proposedValue) {
            buffer.putLong(offset, proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean proposeMaxOrdered(long proposedValue) {
        UnsafeBuffer buffer = this.buffer;
        int offset = this.offset;
        boolean updated = false;
        if (buffer.getLong(offset) < proposedValue) {
            buffer.putLongOrdered(offset, proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public void close() {
        if (null != this.countersManager) {
            this.countersManager.free(this.counterId);
        }
    }
}

