/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.BitUtil;
import org.agrona.UnsafeAccess;
import sun.nio.ch.DirectBuffer;

public class BufferUtil {
    public static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
    public static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    public static final long ARRAY_BASE_OFFSET = UnsafeAccess.UNSAFE.arrayBaseOffset(byte[].class);

    public static void boundsCheck(byte[] buffer, long index, int length) {
        int capacity = buffer.length;
        long resultingPosition = index + (long)length;
        if (index < 0L || resultingPosition > (long)capacity) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, capacity));
        }
    }

    public static void boundsCheck(ByteBuffer buffer, long index, int length) {
        int capacity = buffer.capacity();
        long resultingPosition = index + (long)length;
        if (index < 0L || resultingPosition > (long)capacity) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, capacity));
        }
    }

    public static long address(ByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static ByteBuffer allocateDirectAligned(int capacity, int alignment) {
        if (!BitUtil.isPowerOfTwo(alignment)) {
            throw new IllegalArgumentException("Must be a power of 2: alignment=" + alignment);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity + alignment);
        long address = BufferUtil.address(buffer);
        int remainder = (int)(address & (long)(alignment - 1));
        int offset = alignment - remainder;
        buffer.limit(capacity + offset);
        buffer.position(offset);
        return buffer.slice();
    }
}

