/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.common.spring.connector.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.activiti.core.common.model.connector.ConnectorDefinition;
import org.activiti.core.common.spring.connector.ConnectorDefinitionService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;

@Configuration
@ComponentScan(basePackages={"org.activiti.core.common.spring.connector"})
public class ConnectorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.http.converter.json.Jackson2ObjectMapperBuilder"})
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public ConnectorDefinitionService connectorDefinitionService(@Value(value="${activiti.connectors.dir:classpath:/connectors/}") String connectorRoot, ObjectMapper objectMapper, ResourcePatternResolver resourceLoader) {
        return new ConnectorDefinitionService(connectorRoot, objectMapper, resourceLoader);
    }

    @Bean
    public List<ConnectorDefinition> connectorDefinitions(ConnectorDefinitionService connectorDefinitionService) throws IOException {
        List<ConnectorDefinition> connectorDefinitions = connectorDefinitionService.get();
        return connectorDefinitions == null ? Collections.emptyList() : connectorDefinitions;
    }
}

