/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.tess4j.TessAPI;
import net.sourceforge.tess4j.util.LoggHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadLibs {
    private static final String JNA_LIBRARY_PATH = "jna.library.path";
    public static final String TESS4J_TEMP_DIR = new File(System.getProperty("java.io.tmpdir"), "tess4j").getPath();
    public static final String LIB_NAME = "libtesseract304";
    public static final String LIB_NAME_NON_WIN = "tesseract";
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());

    public static TessAPI getTessAPIInstance() {
        return (TessAPI)Native.loadLibrary((String)LoadLibs.getTesseractLibName(), TessAPI.class);
    }

    public static String getTesseractLibName() {
        return Platform.isWindows() ? LIB_NAME : LIB_NAME_NON_WIN;
    }

    public static synchronized File extractTessResources(String string) {
        File file = null;
        try {
            file = new File(TESS4J_TEMP_DIR, string);
            Enumeration<URL> enumeration = LoadLibs.class.getClassLoader().getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                LoadLibs.copyResources(uRL, file);
            }
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), (Throwable)iOException);
        }
        return file;
    }

    static void copyResources(URL uRL, File file) throws IOException {
        if (uRL == null) {
            return;
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof JarURLConnection) {
            LoadLibs.copyJarResourceToPath((JarURLConnection)uRLConnection, file);
        } else {
            File file2 = new File(uRL.getPath());
            if (file2.isDirectory()) {
                FileUtils.copyDirectory((File)file2, (File)file);
            } else {
                FileUtils.copyFile((File)file2, (File)file);
            }
        }
    }

    static void copyJarResourceToPath(JarURLConnection jarURLConnection, File file) {
        try {
            JarFile jarFile = jarURLConnection.getJarFile();
            String string = jarURLConnection.getEntryName();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (!string2.startsWith(string + "/")) continue;
                String string3 = string2.substring(string.length());
                File file2 = new File(file, string3);
                if (jarEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                file2.deleteOnExit();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)file2);
                IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), (Throwable)iOException);
        }
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        File file = LoadLibs.extractTessResources(Platform.RESOURCE_PREFIX);
        if (file != null && file.exists()) {
            String string = System.getProperty(JNA_LIBRARY_PATH);
            if (null == string || string.isEmpty()) {
                System.setProperty(JNA_LIBRARY_PATH, file.getPath());
            } else {
                System.setProperty(JNA_LIBRARY_PATH, string + File.pathSeparator + file.getPath());
            }
        }
    }
}

