/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.event.WeaveListener;
import com.rc.retroweaver.runtime.ClassLiteral;
import jace.parser.ClassFile;
import jace.parser.ConstantPool;
import jace.parser.attribute.CodeAttribute;
import jace.parser.attribute.LocalVariableTableAttribute;
import jace.parser.constant.ClassConstant;
import jace.parser.constant.Constant;
import jace.parser.constant.NameAndTypeConstant;
import jace.parser.constant.UTF8Constant;
import jace.parser.field.ClassField;
import jace.parser.method.ClassMethod;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.InstructionFinder;

public class RetroWeaver {
    private ClassParser parser;
    private JavaClass javaClass;
    private ClassGen generator;
    private String className;
    private ConstantPoolGen constantPool;
    private String sourcePath;
    private String outputPath;
    private int newVersion;
    private WeaveListener listener = new WeaveListener(){

        public void weavingPath(String sourcePath) {
            System.out.println("[RetroWeaver] Weaving " + sourcePath);
        }
    };
    private static final String newLine = System.getProperty("line.separator");
    private static Map boxTypes = new HashMap();
    private static final String AUTOBOX_CLASS = "com.rc.retroweaver.runtime.Autobox";
    private static final String VALUE_OF_METHOD = "valueOf";
    private static final String CLASS_LITERAL_CLASS = "com.rc.retroweaver.runtime.ClassLiteral";
    private static final String GET_CLASS_METHOD = "getClass";
    private static final String GET_CLASS_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/Class;";

    public RetroWeaver(int version) {
        this.newVersion = version;
    }

    public void weave(String sourcePath, String outputPath) throws IOException {
        this.sourcePath = sourcePath;
        if (outputPath == null) {
            outputPath = sourcePath;
        }
        this.outputPath = outputPath;
        this.listener.weavingPath(sourcePath);
        this.fixupFormat();
        this.parser = new ClassParser(this.outputPath);
        this.javaClass = this.parser.parse();
        this.generator = new ClassGen(this.javaClass);
        this.className = this.generator.getClassName();
        this.constantPool = this.generator.getConstantPool();
        if (this.alreadyAspected()) {
            return;
        }
        this.fixupRuntimeCalls();
        this.generator.getJavaClass().dump(this.outputPath);
    }

    private int updateId(ConstantPool pool, int index) {
        String name;
        UTF8Constant constant = (UTF8Constant)pool.getConstantAt(index);
        String newName = name = constant.toString();
        if (name.indexOf(43) != -1) {
            newName = name.replace('+', '$');
        }
        if (newName.indexOf("java/lang/StringBuilder") != -1) {
            newName = newName.replace("java/lang/StringBuilder", "java/lang/StringBuffer");
        }
        if (newName.indexOf("java/lang/Iterable") != -1) {
            newName = newName.replace("java/lang/Iterable", "com/rc/retroweaver/runtime/Iterable_");
        }
        if (newName.indexOf("java/lang/Enum") != -1) {
            newName = newName.replace("java/lang/Enum", "com/rc/retroweaver/runtime/Enum_");
        }
        if (newName != name) {
            int value = pool.addUTF8(newName);
            return value;
        }
        return -1;
    }

    private void fixupFormat() throws IOException {
        File f;
        String newClassName;
        ClassFile classFile = new ClassFile(this.sourcePath);
        classFile.setVersion(this.newVersion, 0);
        if (classFile.getClassName().indexOf(43) != -1) {
            newClassName = classFile.getClassName().replace('+', '$');
            classFile.setClassName(newClassName);
            String simpleName = "";
            StringTokenizer st = new StringTokenizer(newClassName, "/");
            while (st.hasMoreTokens()) {
                simpleName = st.nextToken();
            }
            f = new File(this.outputPath);
            if (this.sourcePath.equals(this.outputPath)) {
                f.delete();
            }
            File dir = f.getParentFile();
            String name = f.getName();
            this.outputPath = dir.getCanonicalPath() + File.separator + simpleName + ".class";
        }
        newClassName = classFile.getSuperClassName().replace('+', '$');
        newClassName = newClassName.replace("java/lang/Iterable", "com/rc/retroweaver/runtime/Iterable_");
        newClassName = newClassName.replace("java/lang/Enum", "com/rc/retroweaver/runtime/Enum_");
        classFile.setSuperClassName(newClassName);
        ConstantPool pool = classFile.getConstantPool();
        for (int i = 0; i < pool.getSize(); ++i) {
            ClassConstant constant;
            Constant c = pool.getConstant(i);
            if (c instanceof ClassConstant) {
                constant = (ClassConstant)c;
                this.update(pool, constant);
                continue;
            }
            if (!(c instanceof NameAndTypeConstant)) continue;
            constant = (NameAndTypeConstant)c;
            this.update(pool, (NameAndTypeConstant)constant);
        }
        Iterator i$ = classFile.getMethods().iterator();
        while (i$.hasNext()) {
            LocalVariableTableAttribute lvt;
            ClassMethod m = (ClassMethod)i$.next();
            this.update(pool, m);
            CodeAttribute code = m.getCode();
            if (code == null || (lvt = code.getLocalVariableTable()) == null) continue;
            Iterator i$2 = lvt.getVariables().iterator();
            while (i$2.hasNext()) {
                LocalVariableTableAttribute.Variable v = (LocalVariableTableAttribute.Variable)i$2.next();
                this.update(pool, v);
            }
        }
        i$ = classFile.getFields().iterator();
        while (i$.hasNext()) {
            f = (ClassField)i$.next();
            this.update(pool, (ClassField)f);
        }
        classFile.writeClass(this.outputPath);
    }

    private void update(ConstantPool pool, ClassConstant constant) {
        int nameIndex = this.updateId(pool, constant.getNameIndex());
        if (nameIndex != -1) {
            constant.setNameIndex(nameIndex);
        }
    }

    private void update(ConstantPool pool, NameAndTypeConstant constant) {
        int descriptorIndex;
        int nameIndex = this.updateId(pool, constant.getNameIndex());
        if (nameIndex != -1) {
            constant.setNameIndex(nameIndex);
        }
        if ((descriptorIndex = this.updateId(pool, constant.getDescriptorIndex())) != -1) {
            constant.setDescriptorIndex(descriptorIndex);
        }
    }

    private void update(ConstantPool pool, LocalVariableTableAttribute.Variable var) {
        int descriptorIndex;
        int nameIndex = this.updateId(pool, var.nameIndex());
        if (nameIndex != -1) {
            var.setNameIndex(nameIndex);
        }
        if ((descriptorIndex = this.updateId(pool, var.descriptorIndex())) != -1) {
            var.setDescriptorIndex(descriptorIndex);
        }
    }

    private void update(ConstantPool pool, ClassField field) {
        int descriptorIndex;
        int nameIndex = this.updateId(pool, field.getNameIndex());
        if (nameIndex != -1) {
            field.setNameIndex(nameIndex);
        }
        if ((descriptorIndex = this.updateId(pool, field.getDescriptorIndex())) != -1) {
            field.setDescriptorIndex(descriptorIndex);
        }
    }

    private void update(ConstantPool pool, ClassMethod method) {
        int descriptorIndex;
        int nameIndex = this.updateId(pool, method.getNameIndex());
        if (nameIndex != -1) {
            method.setNameIndex(nameIndex);
        }
        if ((descriptorIndex = this.updateId(pool, method.getDescriptorIndex())) != -1) {
            method.setDescriptorIndex(descriptorIndex);
        }
    }

    private void fixupRuntimeCalls() throws IOException {
        Method[] methods = this.generator.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            MethodGen methodGen = new MethodGen(m, this.className, this.constantPool);
            InstructionList list = methodGen.getInstructionList();
            if (list == null) continue;
            this.fixupAutoboxing(list);
            this.fixupClassLiterals(list);
            methodGen.setMaxLocals();
            methodGen.setMaxStack();
            this.generator.removeMethod(m);
            this.generator.addMethod(methodGen.getMethod());
            list.dispose();
        }
    }

    private void fixupAutoboxing(InstructionList list) {
        InstructionFinder finder = new InstructionFinder(list);
        InstructionFinder.CodeConstraint constraint = new InstructionFinder.CodeConstraint(){

            public boolean checkCode(InstructionHandle[] match) {
                INVOKESTATIC instruction = (INVOKESTATIC)match[0].getInstruction();
                String methodName = instruction.getMethodName(RetroWeaver.this.constantPool);
                Type t = instruction.getType(RetroWeaver.this.constantPool);
                Type[] argTypes = instruction.getArgumentTypes(RetroWeaver.this.constantPool);
                boolean matches = methodName.equals(RetroWeaver.VALUE_OF_METHOD) && boxTypes.containsKey(t) && argTypes.length == 1 && argTypes[0] instanceof BasicType;
                return matches;
            }
        };
        Iterator it = finder.search("INVOKESTATIC", constraint);
        if (!it.hasNext()) {
            return;
        }
        while (it.hasNext()) {
            InstructionHandle[] instructions = (InstructionHandle[])it.next();
            InstructionHandle match = instructions[0];
            INVOKESTATIC instruction = (INVOKESTATIC)match.getInstruction();
            Type t = instruction.getType(this.constantPool);
            this.constantPool.addClass(AUTOBOX_CLASS);
            int methodIndex = this.constantPool.addMethodref(AUTOBOX_CLASS, VALUE_OF_METHOD, (String)boxTypes.get(t));
            INVOKESTATIC replacementInstruction = new INVOKESTATIC(methodIndex);
            InstructionHandle handle = list.insert(match, (Instruction)replacementInstruction);
            try {
                list.delete(match);
            }
            catch (TargetLostException e) {
                InstructionHandle[] targets = e.getTargets();
                for (int i = 0; i < targets.length; ++i) {
                    InstructionTargeter[] targeters = targets[i].getTargeters();
                    for (int j = 0; j < targeters.length; ++j) {
                        targeters[j].updateTarget(targets[i], handle);
                    }
                }
            }
        }
    }

    private void fixupClassLiterals(InstructionList list) {
        String searchTerm = "(LDC | LDC_W)";
        InstructionFinder finder = new InstructionFinder(list);
        InstructionFinder.CodeConstraint constraint = new InstructionFinder.CodeConstraint(){

            public boolean checkCode(InstructionHandle[] match) {
                if (match.length != 1) {
                    return false;
                }
                Instruction instruction = match[0].getInstruction();
                if (!(instruction instanceof LDC)) {
                    return false;
                }
                LDC ldc = (LDC)instruction;
                org.apache.bcel.classfile.Constant c = RetroWeaver.this.constantPool.getConstant(ldc.getIndex());
                return c instanceof ConstantClass;
            }
        };
        Iterator it = finder.search("(LDC | LDC_W)", constraint);
        if (!it.hasNext()) {
            return;
        }
        while (it.hasNext()) {
            InstructionHandle[] instructions = (InstructionHandle[])it.next();
            InstructionHandle match = instructions[0];
            LDC instruction = (LDC)match.getInstruction();
            ConstantClass c = (ConstantClass)this.constantPool.getConstant(instruction.getIndex());
            ConstantUtf8 cUtf8 = (ConstantUtf8)this.constantPool.getConstant(c.getNameIndex());
            String className = cUtf8.getBytes();
            int classNameIndex = this.constantPool.addString(className);
            this.constantPool.addClass(CLASS_LITERAL_CLASS);
            int methodIndex = this.constantPool.addMethodref(CLASS_LITERAL_CLASS, GET_CLASS_METHOD, GET_CLASS_SIGNATURE);
            InstructionList newInstructions = new InstructionList();
            newInstructions.append((Instruction)new LDC_W(classNameIndex));
            newInstructions.append((Instruction)new INVOKESTATIC(methodIndex));
            InstructionHandle handle = list.insert(match, newInstructions);
            try {
                list.delete(match);
            }
            catch (TargetLostException e) {
                InstructionHandle[] targets = e.getTargets();
                for (int i = 0; i < targets.length; ++i) {
                    InstructionTargeter[] targeters = targets[i].getTargeters();
                    for (int j = 0; j < targeters.length; ++j) {
                        targeters[j].updateTarget(targets[i], handle);
                    }
                }
            }
            finder.reread();
            it = finder.search("(LDC | LDC_W)", constraint);
        }
    }

    private boolean alreadyAspected() {
        return false;
    }

    public void setListener(WeaveListener listener) {
        this.listener = listener;
    }

    public static String getUsage() {
        return "Usage: RetroWeaver " + newLine + "  <source path>" + newLine + "  [<output path>]";
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println(RetroWeaver.getUsage());
            return;
        }
        String sourcePath = args[0];
        String outputPath = null;
        if (args.length > 1) {
            outputPath = args[1];
        }
        try {
            RetroWeaver weaver = new RetroWeaver(48);
            weaver.weave(sourcePath, outputPath);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        boxTypes.put(Type.getType((Class)ClassLiteral.getClass("java/lang/Boolean")), "(Z)Ljava/lang/Boolean;");
        boxTypes.put(Type.getType((Class)ClassLiteral.getClass("java/lang/Byte")), "(B)Ljava/lang/Byte;");
        boxTypes.put(Type.getType((Class)ClassLiteral.getClass("java/lang/Character")), "(C)Ljava/lang/Character;");
        boxTypes.put(Type.getType((Class)ClassLiteral.getClass("java/lang/Short")), "(S)Ljava/lang/Short;");
        boxTypes.put(Type.getType((Class)ClassLiteral.getClass("java/lang/Integer")), "(I)Ljava/lang/Integer;");
        boxTypes.put(Type.getType((Class)ClassLiteral.getClass("java/lang/Long")), "(J)Ljava/lang/Long;");
        boxTypes.put(Type.getType((Class)ClassLiteral.getClass("java/lang/Float")), "(F)Ljava/lang/Float;");
        boxTypes.put(Type.getType((Class)ClassLiteral.getClass("java/lang/Double")), "(D)Ljava/lang/Double;");
    }
}

