/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@Deprecated
public final class ClassLoaderUtil {
    public static final String CLINIT = "<clinit>";
    public static final String INIT = "<init>";

    private ClassLoaderUtil() {
    }

    public static String fromInternalForm(String internalForm) {
        return internalForm.replace('/', '.');
    }

    public static String toInternalForm(String internalForm) {
        return internalForm.replace('.', '/');
    }

    public static Class<?> getClass(String name) {
        try {
            return ClassLoaderUtil.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(Class<?> type, String name) {
        try {
            return ClassLoaderUtil.myGetField(type, name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field myGetField(Class<?> type, String name) throws NoSuchFieldException {
        try {
            return type.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            for (Class<?> superInterface : type.getInterfaces()) {
                try {
                    return ClassLoaderUtil.myGetField(superInterface, name);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            if (type.getSuperclass() != null) {
                return ClassLoaderUtil.myGetField(type.getSuperclass(), name);
            }
            throw new NoSuchFieldException(type.getName() + "." + name);
        }
    }

    public static Method getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            return ClassLoaderUtil.myGetMethod(type, name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method myGetMethod(Class<?> type, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return type.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                if (type.getSuperclass() != null) {
                    return ClassLoaderUtil.myGetMethod(type.getSuperclass(), name, parameterTypes);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            for (Class<?> superInterface : type.getInterfaces()) {
                try {
                    return ClassLoaderUtil.myGetMethod(superInterface, name, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            throw new NoSuchMethodException(type.getName() + '.' + ClassLoaderUtil.getMethodSignature(name, parameterTypes));
        }
    }

    public static Constructor<?> getConstructor(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMethodSignature(String name, Class<?> ... parameterTypes) {
        StringBuilder builder = new StringBuilder(name);
        if (!name.equals(CLINIT) && !name.equals(INIT)) {
            builder.append('(');
            if (parameterTypes != null && parameterTypes.length > 0) {
                builder.append(parameterTypes[0].getName());
                for (int i = 1; i < parameterTypes.length; ++i) {
                    builder.append(", ").append(parameterTypes[i].getName());
                }
            }
            builder.append(')');
        }
        return builder.toString();
    }

    public static Class<?>[] getParameterTypes(String ... parameterTypeNames) {
        Class[] parameterTypes = new Class[parameterTypeNames.length];
        for (int i = 0; i < parameterTypeNames.length; ++i) {
            parameterTypes[i] = ClassLoaderUtil.getClass(parameterTypeNames[i]);
        }
        return parameterTypes;
    }

    @Deprecated
    public static boolean isOverridenMethod(Class<?> clazz, Method method, boolean checkThisClass) {
        return ClassLoaderUtil.isOverriddenMethod(clazz, method, checkThisClass);
    }

    public static boolean isOverriddenMethod(Class<?> clazz, Method method, boolean checkThisClass) {
        try {
            if (checkThisClass) {
                clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (clazz.getSuperclass() != null && ClassLoaderUtil.isOverriddenMethod(clazz.getSuperclass(), method, true)) {
            return true;
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            if (!ClassLoaderUtil.isOverriddenMethod(anInterface, method, true)) continue;
            return true;
        }
        return false;
    }
}

