/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.GenericToken;
import org.antlr.v4.runtime.Token;

public class AntlrToken
implements GenericToken {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\u000D\\u000A|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]");
    private final Token token;
    private final AntlrToken previousComment;
    private String text;
    private int endline;
    private int endcolumn;

    public AntlrToken(Token token, AntlrToken previousComment) {
        this.token = token;
        this.previousComment = previousComment;
    }

    @Override
    public GenericToken getNext() {
        return null;
    }

    @Override
    public GenericToken getPreviousComment() {
        return this.previousComment;
    }

    @Override
    public String getImage() {
        if (this.text == null) {
            this.text = this.token.getText();
        }
        return this.text;
    }

    @Override
    public int getBeginLine() {
        return this.token.getLine();
    }

    @Override
    public int getBeginColumn() {
        int charPos = this.token.getCharPositionInLine() + 1;
        assert (charPos > 0);
        return charPos;
    }

    @Override
    public int getEndLine() {
        if (this.endline == 0) {
            this.computeEndCoords();
            assert (this.endline > 0);
        }
        return this.endline;
    }

    @Override
    public int getEndColumn() {
        if (this.endcolumn == 0) {
            this.computeEndCoords();
            assert (this.endcolumn > 0);
        }
        return this.endcolumn;
    }

    private void computeEndCoords() {
        String image = this.getImage();
        if (image.length() == 1 && image.charAt(0) != '\n') {
            this.endline = this.getBeginLine();
            this.endcolumn = this.getBeginColumn();
            return;
        }
        Matcher matcher = NEWLINE_PATTERN.matcher(image);
        int numNls = 0;
        int lastOffset = 0;
        int lastLineLen = -1;
        while (matcher.find()) {
            ++numNls;
            lastLineLen = lastLineLen < 0 ? this.token.getCharPositionInLine() + matcher.end() : matcher.end() - lastOffset;
            lastOffset = matcher.end();
        }
        if (numNls == 0) {
            this.endline = this.getBeginLine();
            int length = 1 + this.token.getStopIndex() - this.token.getStartIndex();
            this.endcolumn = this.token.getCharPositionInLine() + length;
        } else if (lastOffset < image.length()) {
            this.endline = this.getBeginLine() + numNls;
            this.endcolumn = image.length() - lastOffset;
        } else {
            this.endline = this.getBeginLine() + numNls - 1;
            this.endcolumn = lastLineLen;
        }
    }

    public int getKind() {
        return this.token.getType();
    }

    @Deprecated
    public int getType() {
        return this.getKind();
    }

    public boolean isHidden() {
        return !this.isDefault();
    }

    public boolean isDefault() {
        return this.token.getChannel() == 0;
    }
}

