/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactoryCompatibility;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.rules.RuleFactory;
import net.sourceforge.pmd.util.ResourceLoader;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RuleSetFactory {
    private static final Logger LOG = Logger.getLogger(RuleSetFactory.class.getName());
    private static final String DESCRIPTION = "description";
    private static final String UNEXPECTED_ELEMENT = "Unexpected element <";
    private static final String PRIORITY = "priority";
    private final ResourceLoader resourceLoader;
    private final RulePriority minimumPriority;
    private final boolean warnDeprecated;
    private final RuleSetFactoryCompatibility compatibilityFilter;
    private final boolean includeDeprecatedRuleReferences;
    private final Map<RuleSetReferenceId, RuleSet> parsedRulesets = new HashMap<RuleSetReferenceId, RuleSet>();

    @Deprecated
    public RuleSetFactory() {
        this(new ResourceLoader(), RulePriority.LOW, false, true);
    }

    @Deprecated
    public RuleSetFactory(ClassLoader classLoader, RulePriority minimumPriority, boolean warnDeprecated, boolean enableCompatibility) {
        this(new ResourceLoader(classLoader), minimumPriority, warnDeprecated, enableCompatibility);
    }

    @Deprecated
    public RuleSetFactory(ResourceLoader resourceLoader, RulePriority minimumPriority, boolean warnDeprecated, boolean enableCompatibility) {
        this(resourceLoader, minimumPriority, warnDeprecated, enableCompatibility, false);
    }

    RuleSetFactory(ResourceLoader resourceLoader, RulePriority minimumPriority, boolean warnDeprecated, boolean enableCompatibility, boolean includeDeprecatedRuleReferences) {
        this.resourceLoader = resourceLoader;
        this.minimumPriority = minimumPriority;
        this.warnDeprecated = warnDeprecated;
        this.includeDeprecatedRuleReferences = includeDeprecatedRuleReferences;
        this.compatibilityFilter = enableCompatibility ? new RuleSetFactoryCompatibility() : null;
    }

    public RuleSetFactory(RuleSetFactory factory, boolean warnDeprecated) {
        this(factory.resourceLoader, factory.minimumPriority, warnDeprecated, factory.compatibilityFilter != null);
    }

    RuleSetFactoryCompatibility getCompatibilityFilter() {
        return this.compatibilityFilter;
    }

    public Iterator<RuleSet> getRegisteredRuleSets() throws RuleSetNotFoundException {
        String rulesetsProperties = null;
        ArrayList<RuleSetReferenceId> ruleSetReferenceIds = new ArrayList<RuleSetReferenceId>();
        for (Language language : LanguageRegistry.findWithRuleSupport()) {
            Properties props = new Properties();
            rulesetsProperties = "category/" + language.getTerseName() + "/categories.properties";
            try {
                InputStream inputStream = this.resourceLoader.loadClassPathResourceAsStreamOrThrow(rulesetsProperties);
                try {
                    props.load(inputStream);
                    String rulesetFilenames = props.getProperty("rulesets.filenames");
                    if (rulesetFilenames == null) continue;
                    ruleSetReferenceIds.addAll(RuleSetReferenceId.parse(rulesetFilenames));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (RuleSetNotFoundException e) {
                LOG.warning("The language " + language.getTerseName() + " provides no " + rulesetsProperties + ".");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Couldn't find " + rulesetsProperties + "; please ensure that the directory is on the classpath. The current classpath is: " + System.getProperty("java.class.path"));
            }
        }
        return this.createRuleSets(ruleSetReferenceIds).getRuleSetsIterator();
    }

    public RuleSets createRuleSets(String referenceString) throws RuleSetNotFoundException {
        return this.createRuleSets(RuleSetReferenceId.parse(referenceString));
    }

    public RuleSets createRuleSets(List<RuleSetReferenceId> ruleSetReferenceIds) throws RuleSetNotFoundException {
        RuleSets ruleSets = new RuleSets();
        for (RuleSetReferenceId ruleSetReferenceId : ruleSetReferenceIds) {
            RuleSet ruleSet = this.createRuleSet(ruleSetReferenceId);
            ruleSets.addRuleSet(ruleSet);
        }
        return ruleSets;
    }

    public RuleSet createRuleSet(String referenceString) throws RuleSetNotFoundException {
        List<RuleSetReferenceId> references = RuleSetReferenceId.parse(referenceString);
        if (references.isEmpty()) {
            throw new RuleSetNotFoundException("No RuleSetReferenceId can be parsed from the string: <" + referenceString + '>');
        }
        return this.createRuleSet(references.get(0));
    }

    public RuleSet createRuleSet(RuleSetReferenceId ruleSetReferenceId) throws RuleSetNotFoundException {
        return this.createRuleSet(ruleSetReferenceId, this.includeDeprecatedRuleReferences);
    }

    private RuleSet createRuleSet(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        return this.parseRuleSetNode(ruleSetReferenceId, withDeprecatedRuleReferences);
    }

    public RuleSet createRuleSetCopy(RuleSet original) {
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(original);
        return builder.build();
    }

    public RuleSet createNewRuleSet(String name, String description, String fileName, Collection<String> excludePatterns, Collection<String> includePatterns, Collection<Rule> rules) {
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(0L);
        builder.withName(name).withDescription(description).withFileName(fileName).replaceFileExclusions(this.toPatterns(excludePatterns)).replaceFileInclusions(this.toPatterns(includePatterns));
        for (Rule rule : rules) {
            builder.addRule(rule);
        }
        return builder.build();
    }

    private Collection<Pattern> toPatterns(Collection<String> sources) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        for (String s : sources) {
            try {
                result.add(Pattern.compile(s));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        return result;
    }

    public RuleSet createSingleRuleRuleSet(Rule rule) {
        long checksum = rule instanceof XPathRule ? (long)((XPathRule)rule).getXPathExpression().hashCode() : (long)(rule.getPropertiesByPropertyDescriptor().values().hashCode() * 31 + rule.getName().hashCode());
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(checksum).withName(rule.getName()).withDescription("RuleSet for " + rule.getName());
        builder.addRule(rule);
        return builder.build();
    }

    private Rule createRule(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        RuleSet ruleSet;
        if (ruleSetReferenceId.isAllRules()) {
            throw new IllegalArgumentException("Cannot parse a single Rule from an all Rule RuleSet reference: <" + ruleSetReferenceId + ">.");
        }
        if (this.parsedRulesets.containsKey(ruleSetReferenceId)) {
            ruleSet = this.parsedRulesets.get(ruleSetReferenceId);
        } else {
            ruleSet = this.createRuleSet(ruleSetReferenceId, withDeprecatedRuleReferences);
            this.parsedRulesets.put(ruleSetReferenceId, ruleSet);
        }
        return ruleSet.getRuleByName(ruleSetReferenceId.getRuleName());
    }

    private RuleSet parseRuleSetNode(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        RuleSet ruleSet;
        CheckedInputStream inputStream = new CheckedInputStream(ruleSetReferenceId.getInputStream(this.resourceLoader), new Adler32());
        try {
            if (!ruleSetReferenceId.isExternal()) {
                throw new IllegalArgumentException("Cannot parse a RuleSet from a non-external reference: <" + ruleSetReferenceId + ">.");
            }
            DocumentBuilder builder = this.createDocumentBuilder();
            InputSource inputSource = this.compatibilityFilter != null ? new InputSource(this.compatibilityFilter.filterRuleSetFile(inputStream)) : new InputSource(inputStream);
            Document document = builder.parse(inputSource);
            Element ruleSetElement = document.getDocumentElement();
            RuleSet.RuleSetBuilder ruleSetBuilder = new RuleSet.RuleSetBuilder(inputStream.getChecksum().getValue()).withFileName(ruleSetReferenceId.getRuleSetFileName());
            if (ruleSetElement.hasAttribute("name")) {
                ruleSetBuilder.withName(ruleSetElement.getAttribute("name"));
            } else {
                LOG.warning("RuleSet name is missing. Future versions of PMD will require it.");
                ruleSetBuilder.withName("Missing RuleSet Name");
            }
            HashSet<String> rulesetReferences = new HashSet<String>();
            NodeList nodeList = ruleSetElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Pattern pattern;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                String text = RuleSetFactory.parseTextNode(node);
                if (DESCRIPTION.equals(nodeName)) {
                    ruleSetBuilder.withDescription(text);
                    continue;
                }
                if ("include-pattern".equals(nodeName)) {
                    pattern = this.parseRegex(text);
                    if (pattern == null) continue;
                    ruleSetBuilder.withFileInclusions(pattern, new Pattern[0]);
                    continue;
                }
                if ("exclude-pattern".equals(nodeName)) {
                    pattern = this.parseRegex(text);
                    if (pattern == null) continue;
                    ruleSetBuilder.withFileExclusions(pattern, new Pattern[0]);
                    continue;
                }
                if ("rule".equals(nodeName)) {
                    this.parseRuleNode(ruleSetReferenceId, ruleSetBuilder, node, withDeprecatedRuleReferences, rulesetReferences);
                    continue;
                }
                throw new IllegalArgumentException(UNEXPECTED_ELEMENT + node.getNodeName() + "> encountered as child of <ruleset> element.");
            }
            if (!ruleSetBuilder.hasDescription()) {
                LOG.warning("RuleSet description is missing. Future versions of PMD will require it.");
                ruleSetBuilder.withDescription("Missing description");
            }
            ruleSetBuilder.filterRulesByPriority(this.minimumPriority);
            ruleSet = ruleSetBuilder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
                throw new RuntimeException("Couldn't find the class " + ex.getMessage(), ex);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                ex.printStackTrace();
                throw new RuntimeException("Couldn't read the ruleset " + ruleSetReferenceId + ": " + ex.getMessage(), ex);
            }
        }
        inputStream.close();
        return ruleSet;
    }

    private Pattern parseRegex(String text) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(text);
        }
        catch (PatternSyntaxException pse) {
            LOG.warning(pse.getMessage());
            return null;
        }
        return pattern;
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            LOG.log(Level.WARNING, "Ignored unsupported XML Parser Feature for parsing rulesets", e);
        }
        return dbf.newDocumentBuilder();
    }

    private void parseRuleNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode, boolean withDeprecatedRuleReferences, Set<String> rulesetReferences) throws ClassNotFoundException, InstantiationException, IllegalAccessException, RuleSetNotFoundException {
        Element ruleElement = (Element)ruleNode;
        String ref = ruleElement.getAttribute("ref");
        if (ref.endsWith("xml")) {
            this.parseRuleSetReferenceNode(ruleSetBuilder, ruleElement, ref, rulesetReferences);
        } else if (StringUtils.isBlank((CharSequence)ref)) {
            this.parseSingleRuleNode(ruleSetReferenceId, ruleSetBuilder, ruleNode);
        } else {
            this.parseRuleReferenceNode(ruleSetReferenceId, ruleSetBuilder, ruleNode, ref, withDeprecatedRuleReferences);
        }
    }

    private void parseRuleSetReferenceNode(RuleSet.RuleSetBuilder ruleSetBuilder, Element ruleElement, String ref, Set<String> rulesetReferences) throws RuleSetNotFoundException {
        String priority = null;
        NodeList childNodes = ruleElement.getChildNodes();
        HashSet<String> excludedRulesCheck = new HashSet<String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (RuleSetFactory.isElementNode(child, "exclude")) {
                Element excludeElement = (Element)child;
                String excludedRuleName = excludeElement.getAttribute("name");
                excludedRulesCheck.add(excludedRuleName);
                continue;
            }
            if (!RuleSetFactory.isElementNode(child, PRIORITY)) continue;
            priority = RuleSetFactory.parseTextNode(child).trim();
        }
        RuleSetReference ruleSetReference = new RuleSetReference(ref, true, excludedRulesCheck);
        RuleSetFactory ruleSetFactory = new RuleSetFactory(this.resourceLoader, RulePriority.LOW, false, this.compatibilityFilter != null);
        RuleSet otherRuleSet = ruleSetFactory.createRuleSet(RuleSetReferenceId.parse(ref).get(0));
        ArrayList<RuleReference> potentialRules = new ArrayList<RuleReference>();
        int countDeprecated = 0;
        for (Rule rule : otherRuleSet.getRules()) {
            excludedRulesCheck.remove(rule.getName());
            if (ruleSetReference.getExcludes().contains(rule.getName())) continue;
            RuleReference ruleReference = new RuleReference(rule, ruleSetReference);
            if (priority != null) {
                ruleReference.setPriority(RulePriority.valueOf(Integer.parseInt(priority)));
            }
            if (rule.isDeprecated()) {
                ++countDeprecated;
            }
            potentialRules.add(ruleReference);
        }
        boolean rulesetDeprecated = false;
        if (!potentialRules.isEmpty() && potentialRules.size() == countDeprecated) {
            rulesetDeprecated = true;
            LOG.warning("The RuleSet " + ref + " has been deprecated and will be removed in PMD " + PMDVersion.getNextMajorRelease());
        }
        for (RuleReference r : potentialRules) {
            if (!rulesetDeprecated && r.getRule().isDeprecated()) continue;
            ruleSetBuilder.addRuleIfNotExists(r);
        }
        if (!excludedRulesCheck.isEmpty() && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Unable to exclude rules " + excludedRulesCheck + " from ruleset reference " + ref + "; perhaps the rule name is misspelled or the rule doesn't exist anymore?");
        }
        if (rulesetReferences.contains(ref)) {
            LOG.warning("The ruleset " + ref + " is referenced multiple times in \"" + ruleSetBuilder.getName() + "\".");
        }
        rulesetReferences.add(ref);
    }

    private void parseSingleRuleNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Element ruleElement = (Element)ruleNode;
        if (StringUtils.isNotBlank((CharSequence)ruleSetReferenceId.getRuleName()) && !this.isRuleName(ruleElement, ruleSetReferenceId.getRuleName())) {
            return;
        }
        Rule rule = new RuleFactory(this.resourceLoader).buildRule(ruleElement);
        rule.setRuleSetName(ruleSetBuilder.getName());
        if (this.warnDeprecated && StringUtils.isBlank((CharSequence)ruleElement.getAttribute("language"))) {
            LOG.warning("Rule " + ruleSetReferenceId.getRuleSetFileName() + "/" + rule.getName() + " does not mention attribute language='" + rule.getLanguage().getTerseName() + "', please mention it explicitly to be compatible with PMD 7");
        }
        ruleSetBuilder.addRule(rule);
    }

    private void parseRuleReferenceNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode, String ref, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        Element ruleElement = (Element)ruleNode;
        if (StringUtils.isNotBlank((CharSequence)ruleSetReferenceId.getRuleName()) && !this.isRuleName(ruleElement, ruleSetReferenceId.getRuleName())) {
            return;
        }
        RuleSetFactory ruleSetFactory = new RuleSetFactory(this.resourceLoader, RulePriority.LOW, false, this.compatibilityFilter != null);
        boolean isSameRuleSet = false;
        RuleSetReferenceId otherRuleSetReferenceId = RuleSetReferenceId.parse(ref).get(0);
        if (!otherRuleSetReferenceId.isExternal() && this.containsRule(ruleSetReferenceId, otherRuleSetReferenceId.getRuleName())) {
            otherRuleSetReferenceId = new RuleSetReferenceId(ref, ruleSetReferenceId);
            isSameRuleSet = true;
        } else if (otherRuleSetReferenceId.isExternal() && otherRuleSetReferenceId.getRuleSetFileName().equals(ruleSetReferenceId.getRuleSetFileName())) {
            otherRuleSetReferenceId = new RuleSetReferenceId(otherRuleSetReferenceId.getRuleName(), ruleSetReferenceId);
            isSameRuleSet = true;
        }
        Rule referencedRule = ruleSetFactory.createRule(otherRuleSetReferenceId, true);
        if (referencedRule == null) {
            throw new IllegalArgumentException("Unable to find referenced rule " + otherRuleSetReferenceId.getRuleName() + "; perhaps the rule name is misspelled?");
        }
        if (this.warnDeprecated && referencedRule.isDeprecated()) {
            if (referencedRule instanceof RuleReference) {
                RuleReference ruleReference = (RuleReference)referencedRule;
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Use Rule name " + ruleReference.getRuleSetReference().getRuleSetFileName() + '/' + ruleReference.getOriginalName() + " instead of the deprecated Rule name " + otherRuleSetReferenceId + ". PMD " + PMDVersion.getNextMajorRelease() + " will remove support for this deprecated Rule name usage.");
                }
            } else if (referencedRule instanceof MockRule) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Discontinue using Rule name " + otherRuleSetReferenceId + " as it has been removed from PMD and no longer functions. PMD " + PMDVersion.getNextMajorRelease() + " will remove support for this Rule.");
                }
            } else if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Discontinue using Rule name " + otherRuleSetReferenceId + " as it is scheduled for removal from PMD. PMD " + PMDVersion.getNextMajorRelease() + " will remove support for this Rule.");
            }
        }
        RuleSetReference ruleSetReference = new RuleSetReference(otherRuleSetReferenceId.getRuleSetFileName(), false);
        RuleReference ruleReference = new RuleFactory(this.resourceLoader).decorateRule(referencedRule, ruleSetReference, ruleElement);
        if (this.warnDeprecated && ruleReference.isDeprecated() && !isSameRuleSet && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Use Rule name " + ruleReference.getRuleSetReference().getRuleSetFileName() + '/' + ruleReference.getOriginalName() + " instead of the deprecated Rule name " + ruleSetReferenceId.getRuleSetFileName() + '/' + ruleReference.getName() + ". PMD " + PMDVersion.getNextMajorRelease() + " will remove support for this deprecated Rule name usage.");
        }
        if (withDeprecatedRuleReferences || !isSameRuleSet || !ruleReference.isDeprecated()) {
            RuleReference existingRuleReference;
            Rule existingRule = ruleSetBuilder.getExistingRule(ruleReference);
            if (existingRule instanceof RuleReference && ((existingRuleReference = (RuleReference)existingRule).hasOverriddenAttributes() || !ruleReference.hasOverriddenAttributes())) {
                LOG.warning("The rule " + ruleReference.getName() + " is referenced multiple times in \"" + ruleSetBuilder.getName() + "\". Only the last rule configuration is used.");
            }
            ruleSetBuilder.addRuleReplaceIfExists(ruleReference);
        }
    }

    private boolean containsRule(RuleSetReferenceId ruleSetReferenceId, String ruleName) {
        boolean found = false;
        try (InputStream ruleSet = ruleSetReferenceId.getInputStream(this.resourceLoader);){
            DocumentBuilder builder = this.createDocumentBuilder();
            Document document = builder.parse(ruleSet);
            Element ruleSetElement = document.getDocumentElement();
            NodeList rules = ruleSetElement.getElementsByTagName("rule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Element rule = (Element)rules.item(i);
                if (!rule.hasAttribute("name") || !rule.getAttribute("name").equals(ruleName)) continue;
                found = true;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return found;
    }

    private static boolean isElementNode(Node node, String name) {
        return node.getNodeType() == 1 && node.getNodeName().equals(name);
    }

    private static String parseTextNode(Node node) {
        int nodeCount = node.getChildNodes().getLength();
        if (nodeCount == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < nodeCount; ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 4 && childNode.getNodeType() != 3) continue;
            buffer.append(childNode.getNodeValue());
        }
        return buffer.toString();
    }

    private boolean isRuleName(Element ruleElement, String ruleName) {
        if (ruleElement.hasAttribute("name")) {
            return ruleElement.getAttribute("name").equals(ruleName);
        }
        if (ruleElement.hasAttribute("ref")) {
            RuleSetReferenceId ruleSetReferenceId = RuleSetReferenceId.parse(ruleElement.getAttribute("ref")).get(0);
            return ruleSetReferenceId.getRuleName() != null && ruleSetReferenceId.getRuleName().equals(ruleName);
        }
        return false;
    }
}

