/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;
import net.sourceforge.pmd.util.StringUtil;

public class CharacterMultiProperty
extends AbstractProperty<Character[]> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<CharacterMultiProperty>(Character[].class){

        public CharacterMultiProperty createWith(Map<String, String> valuesById) {
            char delimiter = 1.delimiterIn(valuesById);
            return new CharacterMultiProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), 1.charsIn(this.defaultValueIn(valuesById), delimiter), 0.0f, delimiter);
        }
    };

    public CharacterMultiProperty(String theName, String theDescription, Character[] theDefaults, float theUIOrder, char delimiter) {
        super(theName, theDescription, theDefaults, theUIOrder, delimiter);
        if (theDefaults != null) {
            for (int i = 0; i < theDefaults.length; ++i) {
                if (theDefaults[i].charValue() != delimiter) continue;
                throw new IllegalArgumentException("Cannot include the delimiter in the set of defaults");
            }
        }
    }

    @Override
    public Class<Character[]> type() {
        return Character[].class;
    }

    @Override
    public Character[] valueFrom(String valueString) throws IllegalArgumentException {
        String[] values = StringUtil.substringsOf(valueString, this.multiValueDelimiter());
        Character[] chars = new Character[values.length];
        for (int i = 0; i < values.length; ++i) {
            chars[i] = Character.valueOf(values[i].charAt(0));
        }
        return chars;
    }

    @Override
    public boolean isMultiValue() {
        return true;
    }
}

