/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.filter;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.util.filter.Filter;

public abstract class AbstractCompoundFilter<T>
implements Filter<T> {
    protected List<Filter<T>> filters;

    public AbstractCompoundFilter() {
        this.filters = new ArrayList<Filter<T>>(2);
    }

    public AbstractCompoundFilter(Filter<T> ... filters) {
        this.filters = new ArrayList<Filter<T>>(filters.length);
        for (Filter<T> filter : filters) {
            this.filters.add(filter);
        }
    }

    public List<Filter<T>> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter<T>> filters) {
        this.filters = filters;
    }

    public void addFilter(Filter<T> filter) {
        this.filters.add(filter);
    }

    protected abstract String getOperator();

    public String toString() {
        if (this.filters.isEmpty()) {
            return "()";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.filters.get(0));
        for (int i = 1; i < this.filters.size(); ++i) {
            builder.append(' ').append(this.getOperator()).append(' ');
            builder.append(this.filters.get(i));
        }
        builder.append(')');
        return builder.toString();
    }
}

