/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.io.IOException;
import java.util.List;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.datasource.DataSource;

public abstract class AbstractPMDProcessor {
    protected final PMDConfiguration configuration;

    public AbstractPMDProcessor(PMDConfiguration configuration) {
        this.configuration = configuration;
    }

    public void renderReports(List<Renderer> renderers, Report report) {
        long start = System.nanoTime();
        try {
            for (Renderer r : renderers) {
                r.renderFileReport(report);
            }
            long end = System.nanoTime();
            Benchmarker.mark(Benchmark.Reporting, end - start, 1L);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected String filenameFrom(DataSource dataSource) {
        return dataSource.getNiceFileName(this.configuration.isReportShortNames(), this.configuration.getInputPaths());
    }

    protected RuleSets createRuleSets(RuleSetFactory factory) {
        return RulesetsFactoryUtils.getRuleSets(this.configuration.getRuleSets(), factory);
    }
}

