/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.HashSet;
import java.util.Map;
import net.sourceforge.pmd.lang.rule.properties.AbstractProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

public abstract class AbstractPackagedProperty<T>
extends AbstractProperty<T> {
    private String[] legalPackageNames;
    private static final char PACKAGE_NAME_DELIMITER = ' ';
    protected static final Map<String, Boolean> PACKAGED_FIELD_TYPES_BY_KEY = BasicPropertyDescriptorFactory.expectedFieldTypesWith(new String[]{"legalPackages"}, new Boolean[]{Boolean.FALSE});

    protected static String[] packageNamesIn(Map<String, String> params) {
        return null;
    }

    protected AbstractPackagedProperty(String theName, String theDescription, T theDefault, String[] theLegalPackageNames, float theUIOrder) {
        super(theName, theDescription, theDefault, theUIOrder);
        this.checkValidPackages(theDefault, theLegalPackageNames);
        this.legalPackageNames = theLegalPackageNames;
    }

    @Override
    protected void addAttributesTo(Map<String, String> attributes) {
        super.addAttributesTo(attributes);
        attributes.put("legalPackages", this.delimitedPackageNames());
    }

    private final String delimitedPackageNames() {
        if (this.legalPackageNames == null || this.legalPackageNames.length == 0) {
            return "";
        }
        if (this.legalPackageNames.length == 1) {
            return this.legalPackageNames[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.legalPackageNames[0]);
        for (int i = 1; i < this.legalPackageNames.length; ++i) {
            sb.append(' ').append(this.legalPackageNames[i]);
        }
        return sb.toString();
    }

    private void checkValidPackages(Object item, String[] legalNamePrefixes) {
        int i;
        Object[] items = new Object[]{};
        if (item != null) {
            items = item.getClass().isArray() ? (Object[])item : new Object[]{item};
        }
        String[] names = new String[items.length];
        HashSet<String> nameSet = new HashSet<String>(items.length);
        String name = null;
        for (i = 0; i < items.length; ++i) {
            names[i] = name = this.packageNameOf(items[i]);
            nameSet.add(name);
        }
        block1: for (i = 0; i < names.length; ++i) {
            for (int l = 0; l < legalNamePrefixes.length; ++l) {
                if (!names[i].startsWith(legalNamePrefixes[l])) continue;
                nameSet.remove(names[i]);
                continue block1;
            }
        }
        if (nameSet.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Invalid items: " + nameSet);
    }

    protected abstract String itemTypeName();

    @Override
    protected String valueErrorFor(Object value) {
        String err;
        if (value == null && (err = super.valueErrorFor(null)) != null) {
            return err;
        }
        if (this.legalPackageNames == null) {
            return null;
        }
        String name = this.packageNameOf(value);
        for (int i = 0; i < this.legalPackageNames.length; ++i) {
            if (!name.startsWith(this.legalPackageNames[i])) continue;
            return null;
        }
        return "Disallowed " + this.itemTypeName() + ": " + name;
    }

    protected abstract String packageNameOf(Object var1);

    public String[] legalPackageNames() {
        return this.legalPackageNames;
    }
}

