/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLRenderer
implements Renderer {
    private String encoding;

    public XMLRenderer() {
        this(null);
    }

    public XMLRenderer(String encoding) {
        this.setEncoding(encoding);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding != null ? encoding : System.getProperty("file.encoding");
    }

    public String getEncoding() {
        return this.encoding;
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            return parser.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private String xmlDocToString(Document doc) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.encoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("cdata-section-elements", "codefragment");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String render(Iterator<Match> matches) {
        Document doc = this.createDocument();
        Element root = doc.createElement("pmd-cpd");
        doc.appendChild(root);
        while (matches.hasNext()) {
            Match match = matches.next();
            root.appendChild(this.addCodeSnippet(doc, this.addFilesToDuplicationElement(doc, this.createDuplicationElement(doc, match), match), match));
        }
        return this.xmlDocToString(doc);
    }

    private Element addFilesToDuplicationElement(Document doc, Element duplication, Match match) {
        Iterator<Mark> iterator = match.iterator();
        while (iterator.hasNext()) {
            Mark mark = iterator.next();
            Element file = doc.createElement("file");
            file.setAttribute("line", String.valueOf(mark.getBeginLine()));
            file.setAttribute("path", mark.getFilename());
            duplication.appendChild(file);
        }
        return duplication;
    }

    private Element addCodeSnippet(Document doc, Element duplication, Match match) {
        String codeSnipet = match.getSourceCodeSlice();
        if (codeSnipet != null) {
            Element codefragment = doc.createElement("codefragment");
            codefragment.appendChild(doc.createCDATASection(codeSnipet));
            duplication.appendChild(codefragment);
        }
        return duplication;
    }

    private Element createDuplicationElement(Document doc, Match match) {
        Element duplication = doc.createElement("duplication");
        duplication.setAttribute("lines", String.valueOf(match.getLineCount()));
        duplication.setAttribute("tokens", String.valueOf(match.getTokenCount()));
        return duplication;
    }
}

