/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lept4j.util;

import com.github.jaiimageio.plugins.tiff.TIFFImageWriteParam;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.lept4j.Box;
import net.sourceforge.lept4j.Boxa;
import net.sourceforge.lept4j.Boxaa;
import net.sourceforge.lept4j.CCBord;
import net.sourceforge.lept4j.CCBorda;
import net.sourceforge.lept4j.DPix;
import net.sourceforge.lept4j.DoubleLinkedList;
import net.sourceforge.lept4j.FPix;
import net.sourceforge.lept4j.FPixa;
import net.sourceforge.lept4j.GPlot;
import net.sourceforge.lept4j.JbClasser;
import net.sourceforge.lept4j.JbData;
import net.sourceforge.lept4j.L_Bmf;
import net.sourceforge.lept4j.L_ByteBuffer;
import net.sourceforge.lept4j.L_Bytea;
import net.sourceforge.lept4j.L_Dewarp;
import net.sourceforge.lept4j.L_Dewarpa;
import net.sourceforge.lept4j.L_Dna;
import net.sourceforge.lept4j.L_DnaHash;
import net.sourceforge.lept4j.L_Dnaa;
import net.sourceforge.lept4j.L_Kernel;
import net.sourceforge.lept4j.L_Rbtree;
import net.sourceforge.lept4j.L_Recog;
import net.sourceforge.lept4j.L_Sudoku;
import net.sourceforge.lept4j.L_WShed;
import net.sourceforge.lept4j.Leptonica1;
import net.sourceforge.lept4j.Numa;
import net.sourceforge.lept4j.Numaa;
import net.sourceforge.lept4j.Pix;
import net.sourceforge.lept4j.PixColormap;
import net.sourceforge.lept4j.PixComp;
import net.sourceforge.lept4j.PixTiling;
import net.sourceforge.lept4j.Pixa;
import net.sourceforge.lept4j.PixaComp;
import net.sourceforge.lept4j.Pixaa;
import net.sourceforge.lept4j.Pixacc;
import net.sourceforge.lept4j.Pta;
import net.sourceforge.lept4j.Ptaa;
import net.sourceforge.lept4j.Sarray;
import net.sourceforge.lept4j.Sela;

public class LeptUtils {
    static final String JAI_IMAGE_WRITER_MESSAGE = "Need to install JAI Image I/O package.\nhttps://github.com/jai-imageio/jai-imageio-core";
    static final String TIFF_FORMAT = "tiff";
    static final float deg2rad = 0.017453277f;

    public static BufferedImage convertPixToImage(Pix pix) throws IOException {
        PointerByReference pointerByReference = new PointerByReference();
        NativeSizeByReference nativeSizeByReference = new NativeSizeByReference();
        int n = 4;
        Leptonica1.pixWriteMem(pointerByReference, nativeSizeByReference, pix, n);
        byte[] byArray = pointerByReference.getValue().getByteArray(0L, nativeSizeByReference.getValue().intValue());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
        ((InputStream)byteArrayInputStream).close();
        Leptonica1.lept_free(pointerByReference.getValue());
        return bufferedImage;
    }

    public static Pix convertImageToPix(BufferedImage bufferedImage) throws IOException {
        ByteBuffer byteBuffer = LeptUtils.getImageByteBuffer(bufferedImage);
        Pix pix = Leptonica1.pixReadMem(byteBuffer, new NativeSize(byteBuffer.capacity()));
        return pix;
    }

    public static Pix removeLines(Pix pix) {
        Pix pix2 = Leptonica1.pixThresholdToBinary(pix, 170);
        FloatBuffer floatBuffer = FloatBuffer.allocate(1);
        FloatBuffer floatBuffer2 = FloatBuffer.allocate(1);
        Leptonica1.pixFindSkew(pix2, floatBuffer, floatBuffer2);
        float f = floatBuffer.get();
        float f2 = floatBuffer2.get();
        Pix pix3 = Leptonica1.pixRotateAMGray(pix, 0.017453277f * f, (byte)-1);
        Pix pix4 = Leptonica1.pixCloseGray(pix3, 51, 1);
        Pix pix5 = Leptonica1.pixErodeGray(pix4, 1, 5);
        Pix pix6 = Leptonica1.pixThresholdToValue(null, pix5, 210, 255);
        Pix pix7 = Leptonica1.pixThresholdToValue(null, pix6, 200, 0);
        Pix pix8 = Leptonica1.pixThresholdToBinary(pix7, 210);
        Leptonica1.pixInvert(pix7, pix7);
        Pix pix9 = Leptonica1.pixAddGray(null, pix3, pix7);
        Pix pix10 = Leptonica1.pixOpenGray(pix9, 1, 9);
        Leptonica1.pixCombineMasked(pix9, pix10, pix8);
        LeptUtils.disposePix(pix2);
        LeptUtils.disposePix(pix3);
        LeptUtils.disposePix(pix4);
        LeptUtils.disposePix(pix5);
        LeptUtils.disposePix(pix6);
        LeptUtils.disposePix(pix7);
        LeptUtils.disposePix(pix8);
        LeptUtils.disposePix(pix10);
        return pix9;
    }

    public static void disposePix(Pix pix) {
        if (pix == null) {
            return;
        }
        PointerByReference pointerByReference = new PointerByReference();
        pointerByReference.setValue(pix.getPointer());
        Leptonica1.pixDestroy(pointerByReference);
    }

    public static void dispose(Structure structure) {
        if (structure == null) {
            return;
        }
        PointerByReference pointerByReference = new PointerByReference();
        pointerByReference.setValue(structure.getPointer());
        if (structure instanceof Pix) {
            Leptonica1.pixDestroy(pointerByReference);
        } else if (structure instanceof Pixa) {
            Leptonica1.pixaDestroy(pointerByReference);
        } else if (structure instanceof Box) {
            Leptonica1.boxDestroy(pointerByReference);
        } else if (structure instanceof Boxa) {
            Leptonica1.boxaDestroy(pointerByReference);
        } else if (structure instanceof L_Bmf) {
            Leptonica1.bmfDestroy(pointerByReference);
        } else if (structure instanceof L_ByteBuffer) {
            Leptonica1.bbufferDestroy(pointerByReference);
        } else if (structure instanceof Boxaa) {
            Leptonica1.boxaaDestroy(pointerByReference);
        } else if (structure instanceof L_Bytea) {
            Leptonica1.l_byteaDestroy(pointerByReference);
        } else if (structure instanceof CCBorda) {
            Leptonica1.ccbaDestroy(pointerByReference);
        } else if (structure instanceof CCBord) {
            Leptonica1.ccbDestroy(pointerByReference);
        } else if (structure instanceof PixColormap) {
            Leptonica1.pixcmapDestroy(pointerByReference);
        } else if (structure instanceof L_Dewarp) {
            Leptonica1.dewarpDestroy(pointerByReference);
        } else if (structure instanceof L_Dewarpa) {
            Leptonica1.dewarpaDestroy(pointerByReference);
        } else if (structure instanceof L_Dna) {
            Leptonica1.l_dnaDestroy(pointerByReference);
        } else if (structure instanceof L_Dnaa) {
            Leptonica1.l_dnaaDestroy(pointerByReference);
        } else if (structure instanceof L_DnaHash) {
            Leptonica1.l_dnaHashDestroy(pointerByReference);
        } else if (structure instanceof FPix) {
            Leptonica1.fpixDestroy(pointerByReference);
        } else if (structure instanceof FPixa) {
            Leptonica1.fpixaDestroy(pointerByReference);
        } else if (structure instanceof DPix) {
            Leptonica1.dpixDestroy(pointerByReference);
        } else if (structure instanceof GPlot) {
            Leptonica1.gplotDestroy(pointerByReference);
        } else if (structure instanceof JbClasser) {
            Leptonica1.jbClasserDestroy(pointerByReference);
        } else if (structure instanceof JbData) {
            Leptonica1.jbDataDestroy(pointerByReference);
        } else if (structure instanceof L_Kernel) {
            Leptonica1.kernelDestroy(pointerByReference);
        } else if (structure instanceof Numa) {
            Leptonica1.numaDestroy(pointerByReference);
        } else if (structure instanceof Numaa) {
            Leptonica1.numaaDestroy(pointerByReference);
        } else if (structure instanceof Pixaa) {
            Leptonica1.pixaaDestroy(pointerByReference);
        } else if (structure instanceof Pixacc) {
            Leptonica1.pixaccDestroy(pointerByReference);
        } else if (structure instanceof PixComp) {
            Leptonica1.pixcompDestroy(pointerByReference);
        } else if (structure instanceof PixaComp) {
            Leptonica1.pixacompDestroy(pointerByReference);
        } else if (structure instanceof PixTiling) {
            Leptonica1.pixTilingDestroy(pointerByReference);
        } else if (structure instanceof Pta) {
            Leptonica1.ptaDestroy(pointerByReference);
        } else if (structure instanceof Ptaa) {
            Leptonica1.ptaaDestroy(pointerByReference);
        } else if (structure instanceof L_Recog) {
            Leptonica1.recogDestroy(pointerByReference);
        } else if (structure instanceof Sarray) {
            Leptonica1.sarrayDestroy(pointerByReference);
        } else if (structure instanceof Sela) {
            Leptonica1.selaDestroy(pointerByReference);
        } else if (structure instanceof L_Sudoku) {
            Leptonica1.sudokuDestroy(pointerByReference);
        } else if (structure instanceof L_WShed) {
            Leptonica1.wshedDestroy(pointerByReference);
        } else if (structure instanceof DoubleLinkedList) {
            Leptonica1.listDestroy(pointerByReference);
        } else if (structure instanceof L_Rbtree) {
            Leptonica1.l_rbtreeDestroy(pointerByReference);
        } else {
            throw new RuntimeException("Not supported.");
        }
    }

    static ByteBuffer getImageByteBuffer(RenderedImage renderedImage) throws IOException {
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        tIFFImageWriteParam.setCompressionMode(0);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator.next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(iIOMetadata, new IIOImage(renderedImage, null, null), (ImageWriteParam)tIFFImageWriteParam);
        imageWriter.dispose();
        imageOutputStream.seek(0L);
        byte[] byArray = new byte[(int)imageOutputStream.length()];
        imageOutputStream.read(byArray);
        imageOutputStream.close();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }
}

