/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.script;

import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.support.Dimension2DImpl;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;

public final class ScriptSupport {
    private ScriptSupport() {
    }

    static void layout(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext, JEuclidElement jEuclidElement, JEuclidElement jEuclidElement2, JEuclidElement jEuclidElement3, JEuclidElement jEuclidElement4, String string, String string2) {
        LayoutInfo layoutInfo2 = layoutView.getInfo(jEuclidElement2);
        float f = layoutInfo2.getWidth(layoutStage);
        LayoutInfo layoutInfo3 = layoutView.getInfo(jEuclidElement3);
        LayoutInfo layoutInfo4 = layoutView.getInfo(jEuclidElement4);
        ShiftInfo shiftInfo = ScriptSupport.calculateScriptShfits(layoutStage, layoutContext, string, string2, layoutInfo2, layoutInfo3, layoutInfo4);
        if (layoutInfo3 != null) {
            layoutInfo3.moveTo(f, shiftInfo.getSubShift(), layoutStage);
        }
        if (layoutInfo4 != null) {
            layoutInfo4.moveTo(f, -shiftInfo.getSuperShift(), layoutStage);
        }
        Dimension2DImpl dimension2DImpl = new Dimension2DImpl(0.0f, 0.0f);
        Dimension2DImpl dimension2DImpl2 = new Dimension2DImpl(0.0f, 0.0f);
        ElementListSupport.fillInfoFromChildren(layoutView, layoutInfo, jEuclidElement, layoutStage, dimension2DImpl, dimension2DImpl2);
        layoutInfo.setStretchAscent(layoutInfo2.getStretchAscent());
        layoutInfo.setStretchDescent(layoutInfo2.getStretchDescent());
    }

    static ShiftInfo calculateScriptShfits(LayoutStage layoutStage, LayoutContext layoutContext, String string, String string2, LayoutInfo layoutInfo, LayoutInfo layoutInfo2, LayoutInfo layoutInfo3) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (layoutInfo2 != null) {
            f = Math.max(layoutInfo.getDescentHeight(layoutStage) + (layoutInfo2.getAscentHeight(layoutStage) - layoutInfo2.getDescentHeight(layoutStage)) / 2.0f, AttributesHelper.convertSizeToPt(string, layoutContext, "pt"));
        }
        if (layoutInfo3 != null) {
            f2 = Math.max(layoutInfo.getAscentHeight(layoutStage) - (layoutInfo3.getAscentHeight(layoutStage) - layoutInfo3.getDescentHeight(layoutStage)) / 2.0f, AttributesHelper.convertSizeToPt(string2, layoutContext, "pt"));
        }
        if (layoutInfo2 != null && layoutInfo3 != null) {
            float f3 = -f + layoutInfo2.getAscentHeight(layoutStage) + 1.0f;
            float f4 = f2 - layoutInfo3.getDescentHeight(layoutStage) - 1.0f;
            float f5 = Math.max(0.0f, f3 - f4);
            float f6 = f5 / 2.0f;
            f2 += f6;
            f += f6;
        }
        return new ShiftInfo(f, f2);
    }

    static class ShiftInfo {
        private float superShift;
        private float subShift;

        protected ShiftInfo(float f, float f2) {
            this.superShift = f2;
            this.subShift = f;
        }

        public float getSuperShift() {
            return this.superShift;
        }

        public float getSubShift() {
            return this.subShift;
        }

        public void max(ShiftInfo shiftInfo) {
            this.subShift = Math.max(this.subShift, shiftInfo.subShift);
            this.superShift = Math.max(this.superShift, shiftInfo.superShift);
        }
    }
}

