/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.handWriting;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sourceforge.javaocr.ocrPlugins.aspectRatio.AspectRatioOCR;
import net.sourceforge.javaocr.ocrPlugins.handWriting.ResultAnalyzer;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.OCRScanner;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImage;
import net.sourceforge.javaocr.scanner.accuracy.AccuracyListenerInterface;
import net.sourceforge.javaocr.scanner.accuracy.OCRComp;
import net.sourceforge.javaocr.scanner.accuracy.OCRIdentification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandwritingOCR
implements AccuracyListenerInterface {
    private final HashMap<Character, ArrayList<TrainingImage>> trainingImages;
    private boolean isDoMSE;
    private boolean isDoAspect;
    private final ArrayList<OCRIdentification> mseCharIdentList;
    private final ArrayList<OCRIdentification> aspectCharIdentList;
    private static final Logger LOG = Logger.getLogger(HandwritingOCR.class.getName());

    public HandwritingOCR(HashMap<Character, ArrayList<TrainingImage>> trainingImages) {
        this.trainingImages = trainingImages;
        this.mseCharIdentList = new ArrayList();
        this.aspectCharIdentList = new ArrayList();
    }

    public String scan(BufferedImage targetBfImage) {
        if (this.isDoMSE) {
            this.doMSEScan(targetBfImage);
        }
        if (this.isDoAspect) {
            this.doAspectRatioScan(targetBfImage);
        }
        ResultAnalyzer resultAnalyzer = new ResultAnalyzer(this.mseCharIdentList, this.aspectCharIdentList);
        return resultAnalyzer.calculateResultAndReturnString();
    }

    public void processCharOrSpace(OCRIdentification charIdent) {
        if (charIdent.getOCRType() == OCRComp.MSE) {
            this.mseCharIdentList.add(charIdent);
        } else if (charIdent.getOCRType() == OCRComp.ASPECT_RATIO) {
            this.aspectCharIdentList.add(charIdent);
        }
    }

    private void doMSEScan(BufferedImage targetBfImage) {
        OCRScanner ocrScanner = new OCRScanner();
        ocrScanner.acceptAccuracyListener(this);
        ocrScanner.addTrainingImages(this.trainingImages);
        ocrScanner.scan(targetBfImage, 0, 0, 0, 0, null);
    }

    private void doAspectRatioScan(BufferedImage targetBfImage) {
        AspectRatioOCR ocrScanner = new AspectRatioOCR(this.trainingImages);
        ocrScanner.acceptAccuracyListener(this);
        ocrScanner.scan(targetBfImage);
    }

    public void setEnableMSEOCR(boolean enable) {
        this.isDoMSE = enable;
    }

    public void setEnableAspectOCR(boolean enable) {
        this.isDoAspect = enable;
    }
}

