/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import java.util.Arrays;
import java.util.HashSet;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class DOMTokenList
extends HtmlUnitScriptable {
    private static final String WHITESPACE_CHARS = " \t\r\n\f";
    private static final String WHITESPACE_CHARS_IE_11 = " \t\r\n\f\u000b";
    private String attributeName_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DOMTokenList() {
    }

    public DOMTokenList(Node node, String attributeName) {
        this.setDomNode(node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributeName_ = attributeName;
    }

    @JsxGetter
    public int getLength() {
        Object value = this.getDefaultValue((Class)null);
        String[] parts = StringUtils.split((String)value, (String)this.whitespaceChars());
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_LENGTH_IGNORES_DUPLICATES)) {
            HashSet<String> elements = new HashSet<String>(parts.length);
            elements.addAll(Arrays.asList(parts));
            return elements.size();
        }
        return parts.length;
    }

    @Override
    public String getDefaultValue(Class<?> hint) {
        DomAttr attr;
        if (this.getPrototype() == null) {
            return (String)super.getDefaultValue(hint);
        }
        DomNode node = this.getDomNodeOrNull();
        if (node != null && (attr = (DomAttr)node.getAttributes().getNamedItem(this.attributeName_)) != null) {
            return String.join((CharSequence)" ", StringUtils.split((String)attr.getValue(), (String)this.whitespaceChars()));
        }
        return "";
    }

    @JsxFunction
    public void add(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw Context.reportRuntimeError((String)"Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)this.whitespaceChars())) {
            throw Context.reportRuntimeError((String)"Empty input not allowed");
        }
        Object value = this.getDefaultValue((Class)null);
        boolean changed = false;
        if (this.position((String)value, token) < 0) {
            if (((String)value).length() != 0 && !this.isWhitespace(((String)value).charAt(((String)value).length() - 1))) {
                value = (String)value + " ";
            }
            value = (String)value + token;
            changed = true;
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_REMOVE_WHITESPACE_CHARS_ON_ADD)) {
            value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)this.whitespaceChars()));
            changed = true;
        }
        if (changed) {
            this.updateAttribute((String)value);
        }
    }

    @JsxFunction
    public void remove(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw Context.reportRuntimeError((String)"Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)this.whitespaceChars())) {
            throw Context.reportRuntimeError((String)"Empty input not allowed");
        }
        Object value = this.getDefaultValue((Class)null);
        boolean changed = false;
        int pos = this.position((String)value, token);
        while (pos != -1) {
            int from;
            int to = pos + token.length();
            for (from = pos; from > 0 && this.isWhitespace(((String)value).charAt(from - 1)); --from) {
            }
            while (to < ((String)value).length() - 1 && this.isWhitespace(((String)value).charAt(to))) {
                ++to;
            }
            StringBuilder result = new StringBuilder();
            if (from > 0) {
                result.append((CharSequence)value, 0, from);
                if (to < ((String)value).length()) {
                    result.append(' ');
                }
            }
            result.append((CharSequence)value, to, ((String)value).length());
            value = result.toString();
            changed = true;
            pos = this.position((String)value, token);
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_REMOVE_WHITESPACE_CHARS_ON_REMOVE)) {
            value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)this.whitespaceChars()));
            changed = true;
        }
        if (changed) {
            this.updateAttribute((String)value);
        }
    }

    @JsxFunction
    public boolean toggle(String token) {
        if (this.contains(token)) {
            this.remove(token);
            return false;
        }
        this.add(token);
        return true;
    }

    @JsxFunction
    public boolean contains(String token) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_CONTAINS_RETURNS_FALSE_FOR_BLANK) && StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw Context.reportRuntimeError((String)"Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)this.whitespaceChars())) {
            throw Context.reportRuntimeError((String)"Empty input not allowed");
        }
        return this.position((String)this.getDefaultValue((Class)null), token) > -1;
    }

    @JsxFunction
    public Object item(int index) {
        if (index < 0) {
            return null;
        }
        Object value = this.getDefaultValue((Class)null);
        String[] values = StringUtils.split((String)value, (String)this.whitespaceChars());
        if (index < values.length) {
            return values[index];
        }
        return null;
    }

    public Object get(int index, Scriptable start) {
        Object value = this.item(index);
        if (value == null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_GET_NULL_IF_OUTSIDE)) {
            return Undefined.instance;
        }
        return value;
    }

    private void updateAttribute(String value) {
        DomElement domNode = (DomElement)this.getDomNodeOrDie();
        DomAttr attr = (DomAttr)domNode.getAttributes().getNamedItem(this.attributeName_);
        if (null == attr) {
            attr = domNode.getPage().createAttribute(this.attributeName_);
        }
        attr.setValue(value);
        domNode.setAttributeNode(attr);
    }

    private int position(String value, String token) {
        int pos = value.indexOf(token);
        if (pos < 0) {
            return -1;
        }
        if (pos != 0 && !this.isWhitespace(value.charAt(pos - 1))) {
            return -1;
        }
        int end = pos + token.length();
        if (end != value.length() && !this.isWhitespace(value.charAt(end))) {
            return -1;
        }
        return pos;
    }

    private String whitespaceChars() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_ENHANCED_WHITESPACE_CHARS)) {
            return WHITESPACE_CHARS_IE_11;
        }
        return WHITESPACE_CHARS;
    }

    private boolean isWhitespace(int ch) {
        return this.whitespaceChars().indexOf(ch) > -1;
    }
}

