/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLButtonElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLInputElement;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass(domClass=HtmlForm.class)
public class HTMLFormElement
extends HTMLElement
implements Function {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public HTMLFormElement() {
    }

    @Override
    public void setHtmlElement(HtmlElement htmlElement) {
        super.setHtmlElement(htmlElement);
        HtmlForm htmlForm = this.getHtmlForm();
        htmlForm.setScriptableObject(this);
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getHtmlForm().getNameAttribute();
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getHtmlForm().setNameAttribute(name);
    }

    @JsxGetter
    public HTMLCollection getElements() {
        final HtmlForm htmlForm = this.getHtmlForm();
        return new HTMLCollection(htmlForm, false){
            private boolean filterChildrenOfNestedForms_;

            @Override
            protected List<DomNode> computeElements() {
                List<DomNode> response = super.computeElements();
                if (this.filterChildrenOfNestedForms_) {
                    Iterator<DomNode> iter = response.iterator();
                    while (iter.hasNext()) {
                        HtmlElement field = (HtmlElement)iter.next();
                        if (field.getEnclosingForm() == htmlForm) continue;
                        iter.remove();
                    }
                }
                response.addAll(htmlForm.getLostChildren());
                return response;
            }

            @Override
            protected Object getWithPreemption(String name) {
                return HTMLFormElement.this.getWithPreemption(name);
            }

            @Override
            public AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                return AbstractList.EffectOnCache.NONE;
            }

            @Override
            protected boolean isMatching(DomNode node) {
                if (node instanceof HtmlForm) {
                    this.filterChildrenOfNestedForms_ = true;
                    return false;
                }
                return node instanceof HtmlInput || node instanceof HtmlButton || node instanceof HtmlTextArea || node instanceof HtmlSelect;
            }
        };
    }

    @JsxGetter
    public int getLength() {
        int all = this.getElements().getLength();
        int images = this.getHtmlForm().getElementsByAttribute("input", "type", "image").size();
        return all - images;
    }

    @JsxGetter
    public String getAction() {
        String action = this.getHtmlForm().getActionAttribute();
        if (action == DomElement.ATTRIBUTE_NOT_DEFINED && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_ACTION_EXPANDURL_NOT_DEFINED)) {
            return action;
        }
        try {
            return ((HtmlPage)this.getHtmlForm().getPage()).getFullyQualifiedUrl(action).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return action;
        }
    }

    @JsxSetter
    public void setAction(String action) {
        WebAssert.notNull("action", action);
        this.getHtmlForm().setActionAttribute(action);
    }

    @JsxGetter
    public String getMethod() {
        return this.getHtmlForm().getMethodAttribute();
    }

    @JsxSetter
    public void setMethod(String method) {
        WebAssert.notNull("method", method);
        this.getHtmlForm().setMethodAttribute(method);
    }

    @JsxGetter
    public String getTarget() {
        return this.getHtmlForm().getTargetAttribute();
    }

    @JsxSetter
    public void setTarget(String target) {
        WebAssert.notNull("target", target);
        this.getHtmlForm().setTargetAttribute(target);
    }

    @JsxGetter
    public String getEnctype() {
        String encoding = this.getHtmlForm().getEnctypeAttribute();
        if (!(FormEncodingType.URL_ENCODED.getName().equals(encoding) || FormEncodingType.MULTIPART.getName().equals(encoding) || "text/plain".equals(encoding))) {
            return FormEncodingType.URL_ENCODED.getName();
        }
        return encoding;
    }

    @JsxSetter
    public void setEnctype(String enctype) {
        WebAssert.notNull("encoding", enctype);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_REJECT_INVALID_ENCODING) && !FormEncodingType.URL_ENCODED.getName().equals(enctype) && !FormEncodingType.MULTIPART.getName().equals(enctype) && !FormEncodingType.TEXT_PLAIN.getName().equals(enctype)) {
            throw Context.reportRuntimeError((String)("Cannot set the encoding property to invalid value: '" + enctype + "'"));
        }
        this.getHtmlForm().setEnctypeAttribute(enctype);
    }

    @JsxGetter
    public String getEncoding() {
        return this.getEnctype();
    }

    @JsxSetter
    public void setEncoding(String encoding) {
        this.setEnctype(encoding);
    }

    public HtmlForm getHtmlForm() {
        return (HtmlForm)this.getDomNodeOrDie();
    }

    @JsxFunction
    public void submit() {
        HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
        WebClient webClient = page.getWebClient();
        String action = this.getHtmlForm().getActionAttribute().trim();
        if (StringUtils.startsWithIgnoreCase((CharSequence)action, (CharSequence)"javascript:")) {
            String js = action.substring("javascript:".length());
            webClient.getJavaScriptEngine().execute(page, js, "Form action", 0);
        } else {
            WebRequest request = this.getHtmlForm().getWebRequest(null);
            String target = page.getResolvedTarget(this.getTarget());
            boolean forceDownload = webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_SUBMIT_FORCES_DOWNLOAD);
            boolean checkHash = !webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_DOWNLOWDS_ALSO_IF_ONLY_HASH_CHANGED);
            webClient.download(page.getEnclosingWindow(), target, request, checkHash, forceDownload, "JS form.submit()");
        }
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void requestSubmit(Object submitter) {
        SubmittableElement submittable = null;
        if (Undefined.isUndefined((Object)submitter)) {
            this.submit();
            return;
        }
        if (submitter instanceof HTMLElement) {
            HTMLElement subHtmlElement = (HTMLElement)submitter;
            if (subHtmlElement instanceof HTMLButtonElement) {
                if ("submit".equals(((HTMLButtonElement)subHtmlElement).getType())) {
                    submittable = (SubmittableElement)((Object)subHtmlElement.getDomNodeOrDie());
                }
            } else if (subHtmlElement instanceof HTMLInputElement && "submit".equals(((HTMLInputElement)subHtmlElement).getType())) {
                submittable = (SubmittableElement)((Object)subHtmlElement.getDomNodeOrDie());
            }
            if (submittable != null && subHtmlElement.getForm() != this) {
                throw ScriptRuntime.typeError((String)"Failed to execute 'requestSubmit' on 'HTMLFormElement': The specified element is not owned by this form element.");
            }
        }
        if (submittable == null) {
            throw ScriptRuntime.typeError((String)"Failed to execute 'requestSubmit' on 'HTMLFormElement': The specified element is not a submit button.");
        }
        this.getHtmlForm().submit(submittable);
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object item(Object index, Object subIndex) {
        if (index instanceof Number) {
            return this.getElements().item(index);
        }
        String name = Context.toString((Object)index);
        Object response = this.getWithPreemption(name);
        if (subIndex instanceof Number && response instanceof HTMLCollection) {
            return ((HTMLCollection)response).item(subIndex);
        }
        return response;
    }

    @JsxFunction
    public void reset() {
        this.getHtmlForm().reset();
    }

    @Override
    protected Object getWithPreemption(final String name) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        List<HtmlElement> elements = this.findElements(name);
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            return this.getScriptableFor(elements.get(0));
        }
        ArrayList<HtmlElement> nodes = new ArrayList<HtmlElement>(elements);
        return new HTMLCollection(this.getHtmlForm(), nodes){

            @Override
            protected List<DomNode> computeElements() {
                return new ArrayList<DomNode>(HTMLFormElement.this.findElements(name));
            }
        };
    }

    private List<HtmlElement> findElements(String name) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        this.addElements(name, this.getHtmlForm().getHtmlElementDescendants(), elements);
        this.addElements(name, this.getHtmlForm().getLostChildren(), elements);
        if (elements.isEmpty()) {
            for (DomNode domNode : this.getHtmlForm().getHtmlElementDescendants()) {
                HtmlImage img;
                if (!(domNode instanceof HtmlImage) || !name.equals((img = (HtmlImage)domNode).getId()) && !name.equals(img.getNameAttribute())) continue;
                elements.add(img);
            }
        }
        return elements;
    }

    private void addElements(String name, Iterable<HtmlElement> nodes, List<HtmlElement> addTo) {
        for (HtmlElement node : nodes) {
            if (!this.isAccessibleByIdOrName(node, name)) continue;
            addTo.add(node);
        }
    }

    private boolean isAccessibleByIdOrName(HtmlElement element, String name) {
        if (element instanceof FormFieldWithNameHistory && !(element instanceof HtmlImageInput)) {
            if (element.getEnclosingForm() != this.getHtmlForm()) {
                return false;
            }
            if (name.equals(element.getId())) {
                return true;
            }
            FormFieldWithNameHistory elementWithNames = (FormFieldWithNameHistory)((Object)element);
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.FORMFIELD_REACHABLE_BY_ORIGINAL_NAME) ? name.equals(elementWithNames.getOriginalName()) : name.equals(element.getAttributeDirect("name"))) {
                return true;
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.FORMFIELD_REACHABLE_BY_NEW_NAMES) && elementWithNames.getNewNames().contains(name)) {
                return true;
            }
        }
        return false;
    }

    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.getElements().get(index, (Scriptable)((HTMLFormElement)start).getElements());
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_USABLE_AS_FUNCTION)) {
            throw Context.reportRuntimeError((String)"Not a function.");
        }
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof String) {
                return ScriptableObject.getProperty((Scriptable)this, (String)((String)arg));
            }
            if (arg instanceof Number) {
                return ScriptableObject.getProperty((Scriptable)this, (int)((Number)arg).intValue());
            }
        }
        return Undefined.instance;
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_USABLE_AS_FUNCTION)) {
            throw Context.reportRuntimeError((String)"Not a function.");
        }
        return null;
    }

    @Override
    public boolean dispatchEvent(Event event) {
        boolean result = super.dispatchEvent(event);
        if ("submit".equals(event.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_DISPATCHEVENT_SUBMITS)) {
            this.submit();
        }
        return result;
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }
}

