/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.CloseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import com.gargoylesoftware.htmlunit.websocket.JettyWebSocketAdapter;
import com.gargoylesoftware.htmlunit.websocket.WebSocketAdapter;
import java.io.IOException;
import java.net.URI;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class WebSocket
extends EventTarget
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(WebSocket.class);
    @JsxConstant
    public static final int CONNECTING = 0;
    @JsxConstant
    public static final int OPEN = 1;
    @JsxConstant
    public static final int CLOSING = 2;
    @JsxConstant
    public static final int CLOSED = 3;
    private Function closeHandler_;
    private Function errorHandler_;
    private Function messageHandler_;
    private Function openHandler_;
    private URI url_;
    private int readyState_ = 0;
    private String binaryType_ = "blob";
    private HtmlPage containingPage_;
    private WebSocketAdapter webSocketImpl_;
    private boolean originSet_;

    public WebSocket() {
    }

    private WebSocket(final String url, Window window) {
        try {
            WebWindow webWindow = window.getWebWindow();
            this.containingPage_ = (HtmlPage)webWindow.getEnclosedPage();
            this.setParentScope((Scriptable)window);
            this.setDomNode(this.containingPage_.getDocumentElement(), false);
            WebClient webClient = webWindow.getWebClient();
            this.originSet_ = webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.WEBSOCKET_ORIGIN_SET);
            this.webSocketImpl_ = new JettyWebSocketAdapter(webClient){

                @Override
                public void onWebSocketConnecting() {
                    WebSocket.this.setReadyState(0);
                }

                @Override
                public void onWebSocketConnect() {
                    WebSocket.this.setReadyState(1);
                    Event openEvent = new Event();
                    openEvent.setType("open");
                    openEvent.setSrcElement(WebSocket.this);
                    WebSocket.this.fire(openEvent);
                    WebSocket.this.callFunction(WebSocket.this.openHandler_, new Object[]{openEvent});
                }

                @Override
                public void onWebSocketClose(int statusCode, String reason) {
                    WebSocket.this.setReadyState(3);
                    CloseEvent closeEvent = new CloseEvent();
                    closeEvent.setCode(statusCode);
                    closeEvent.setReason(reason);
                    closeEvent.setWasClean(true);
                    WebSocket.this.fire(closeEvent);
                    WebSocket.this.callFunction(WebSocket.this.closeHandler_, new Object[]{closeEvent});
                }

                @Override
                public void onWebSocketText(String message) {
                    MessageEvent msgEvent = new MessageEvent(message);
                    if (WebSocket.this.originSet_) {
                        msgEvent.setOrigin(WebSocket.this.getUrl());
                    }
                    msgEvent.setSrcElement(WebSocket.this);
                    WebSocket.this.fire(msgEvent);
                    WebSocket.this.callFunction(WebSocket.this.messageHandler_, new Object[]{msgEvent});
                }

                @Override
                public void onWebSocketBinary(byte[] data, int offset, int length) {
                    NativeArrayBuffer buffer = new NativeArrayBuffer((double)length);
                    System.arraycopy(data, offset, buffer.getBuffer(), 0, length);
                    buffer.setParentScope(WebSocket.this.getParentScope());
                    buffer.setPrototype(ScriptableObject.getClassPrototype((Scriptable)WebSocket.this.getWindow(), (String)buffer.getClassName()));
                    MessageEvent msgEvent = new MessageEvent(buffer);
                    if (WebSocket.this.originSet_) {
                        msgEvent.setOrigin(WebSocket.this.getUrl());
                    }
                    msgEvent.setSrcElement(WebSocket.this);
                    WebSocket.this.fire(msgEvent);
                    WebSocket.this.callFunction(WebSocket.this.messageHandler_, new Object[]{msgEvent});
                }

                @Override
                public void onWebSocketConnectError(Throwable cause) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("WS connect error for url '" + url + "':"), cause);
                    }
                }

                @Override
                public void onWebSocketError(Throwable cause) {
                    WebSocket.this.setReadyState(3);
                    Event errorEvent = new Event();
                    errorEvent.setType("error");
                    errorEvent.setSrcElement(WebSocket.this);
                    WebSocket.this.fire(errorEvent);
                    WebSocket.this.callFunction(WebSocket.this.errorHandler_, new Object[]{errorEvent});
                    CloseEvent closeEvent = new CloseEvent();
                    closeEvent.setCode(1006);
                    closeEvent.setReason(cause.getMessage());
                    closeEvent.setWasClean(false);
                    WebSocket.this.fire(closeEvent);
                    WebSocket.this.callFunction(WebSocket.this.closeHandler_, new Object[]{closeEvent});
                }
            };
            this.webSocketImpl_.start();
            this.containingPage_.addAutoCloseable(this);
            this.url_ = new URI(url);
            webClient.getInternals().created(this);
            this.webSocketImpl_.connect(this.url_);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("WebSocket Error: 'url' parameter '" + url + "' is invalid."), (Throwable)e);
            }
            throw Context.reportRuntimeError((String)("WebSocket Error: 'url' parameter '" + url + "' is invalid."));
        }
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError((String)"WebSocket Error: constructor must have one or two String parameters.");
        }
        if (Undefined.isUndefined((Object)args[0])) {
            throw Context.reportRuntimeError((String)"WebSocket Error: 'url' parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"WebSocket Error: 'url' parameter must be a String.");
        }
        String url = (String)args[0];
        if (StringUtils.isBlank((CharSequence)url)) {
            throw Context.reportRuntimeError((String)"WebSocket Error: 'url' parameter must be not empty.");
        }
        return new WebSocket(url, WebSocket.getWindow((Scriptable)ctorObj));
    }

    @JsxGetter
    public Function getOnclose() {
        return this.closeHandler_;
    }

    @JsxSetter
    public void setOnclose(Function closeHandler) {
        this.closeHandler_ = closeHandler;
    }

    @JsxGetter
    public Function getOnerror() {
        return this.errorHandler_;
    }

    @JsxSetter
    public void setOnerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.messageHandler_;
    }

    @JsxSetter
    public void setOnmessage(Function messageHandler) {
        this.messageHandler_ = messageHandler;
    }

    @JsxGetter
    public Function getOnopen() {
        return this.openHandler_;
    }

    @JsxSetter
    public void setOnopen(Function openHandler) {
        this.openHandler_ = openHandler;
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    private void setReadyState(int readyState) {
        this.readyState_ = readyState;
    }

    @JsxGetter
    public String getUrl() {
        if (this.url_ == null) {
            throw ScriptRuntime.typeError((String)"invalid call");
        }
        return this.url_.toString();
    }

    @JsxGetter
    public String getProtocol() {
        return "";
    }

    @JsxGetter
    public long getBufferedAmount() {
        return 0L;
    }

    @JsxGetter
    public String getBinaryType() {
        return this.binaryType_;
    }

    @JsxSetter
    public void setBinaryType(String type) {
        if ("arraybuffer".equals(type) || "blob".equals(type)) {
            this.binaryType_ = type;
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null, null);
    }

    @JsxFunction
    public void close(Object code, Object reason) {
        if (this.readyState_ != 3) {
            try {
                this.webSocketImpl_.closeIncommingSession();
            }
            catch (Throwable e) {
                LOG.error((Object)"WS close error - incomingSession_.close() failed", e);
            }
            try {
                this.webSocketImpl_.closeOutgoingSession();
            }
            catch (Throwable e) {
                LOG.error((Object)"WS close error - outgoingSession_.close() failed", e);
            }
        }
        try {
            this.webSocketImpl_.closeClinet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @JsxFunction
    public void send(Object content) {
        try {
            this.webSocketImpl_.send(content);
        }
        catch (IOException e) {
            LOG.error((Object)"WS send error", (Throwable)e);
        }
    }

    private void fire(Event evt) {
        evt.setTarget(this);
        evt.setParentScope(this.getParentScope());
        evt.setPrototype(this.getPrototype(evt.getClass()));
        JavaScriptEngine engine = (JavaScriptEngine)this.containingPage_.getWebClient().getJavaScriptEngine();
        engine.getContextFactory().call(cx -> {
            this.executeEventLocally(evt);
            return null;
        });
    }

    private void callFunction(Function function, Object[] args) {
        if (function == null) {
            return;
        }
        Scriptable scope = function.getParentScope();
        JavaScriptEngine engine = (JavaScriptEngine)this.containingPage_.getWebClient().getJavaScriptEngine();
        engine.callFunction(this.containingPage_, function, scope, (Scriptable)this, args);
    }
}

