/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlRangeInput
extends HtmlInput
implements LabelableElement {
    HtmlRangeInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        String value = this.getValueAttribute();
        if (value == ATTRIBUTE_NOT_DEFINED) {
            double min = this.getMinNumeric();
            double max = this.getMaxNumeric();
            if (max < min) {
                this.setValueAttribute(min);
                return;
            }
            double val = min + (max - min) / 2.0;
            this.setValueAttribute(val);
        } else {
            this.setValueAttribute(value);
        }
    }

    public double getMinNumeric() {
        String min = this.getAttributeDirect("min");
        if (min == ATTRIBUTE_NOT_DEFINED) {
            return 0.0;
        }
        try {
            return Double.parseDouble(min);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public double getMaxNumeric() {
        String max = this.getAttributeDirect("max");
        if (max == ATTRIBUTE_NOT_DEFINED) {
            return 100.0;
        }
        try {
            return Double.parseDouble(max);
        }
        catch (NumberFormatException e) {
            return 100.0;
        }
    }

    public double getStepNumeric() {
        String step = this.getAttributeDirect("step");
        if (step == ATTRIBUTE_NOT_DEFINED) {
            return 1.0;
        }
        try {
            return Double.parseDouble(step);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.getValueAttribute().equals(this.getDefaultValue());
        this.setDefaultValue(defaultValue, modifyValue);
    }

    @Override
    public void setValueAttribute(String newValue) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)newValue)) {
                this.setValueAttribute(Double.parseDouble(newValue));
            } else {
                double min = this.getMinNumeric();
                double max = this.getMaxNumeric();
                this.setValueAttribute(min + (max - min) / 2.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setValueAttribute(double newValue) {
        double value = newValue;
        double min = this.getMinNumeric();
        double max = this.getMaxNumeric();
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        double step = this.getStepNumeric();
        int fact = (int)((value -= min) / step);
        double rest = value % step;
        if (rest >= step / 2.0) {
            ++fact;
        }
        if (!Double.isInfinite(value = min + step * (double)fact) && value == Math.floor(value)) {
            super.setValueAttribute(Integer.toString((int)value));
        } else {
            super.setValueAttribute(Double.toString(value));
        }
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }
}

