/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.CSSParseException;
import com.gargoylesoftware.css.parser.CSSParser;
import com.gargoylesoftware.css.parser.javacc.CSS3Parser;
import com.gargoylesoftware.css.parser.selector.Selector;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.CharacterDataChangeEvent;
import com.gargoylesoftware.htmlunit.html.CharacterDataChangeListener;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSerializer;
import com.gargoylesoftware.htmlunit.html.HtmlSerializerVisibleText;
import com.gargoylesoftware.htmlunit.html.NamedAttrNodeMapImpl;
import com.gargoylesoftware.htmlunit.html.SiblingDomNodeList;
import com.gargoylesoftware.htmlunit.html.StaticDomNodeList;
import com.gargoylesoftware.htmlunit.html.XmlSerializer;
import com.gargoylesoftware.htmlunit.html.xpath.XPathHelper;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.xml.utils.PrefixResolver;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class DomNode
implements Cloneable,
Serializable,
Node {
    protected static final String AS_TEXT_BLOCK_SEPARATOR = "\u00a7bs\u00a7";
    protected static final String AS_TEXT_NEW_LINE = "\u00a7nl\u00a7";
    protected static final String AS_TEXT_BLANK = "\u00a7blank\u00a7";
    protected static final String AS_TEXT_TAB = "\u00a7tab\u00a7";
    public static final String READY_STATE_UNINITIALIZED = "uninitialized";
    public static final String READY_STATE_LOADING = "loading";
    public static final String READY_STATE_LOADED = "loaded";
    public static final String READY_STATE_INTERACTIVE = "interactive";
    public static final String READY_STATE_COMPLETE = "complete";
    public static final String PROPERTY_ELEMENT = "element";
    private SgmlPage page_;
    private DomNode parent_;
    private DomNode previousSibling_;
    private DomNode nextSibling_;
    private DomNode firstChild_;
    private Object scriptObject_;
    private String readyState_ = "loading";
    private int startLineNumber_ = -1;
    private int startColumnNumber_ = -1;
    private int endLineNumber_ = -1;
    private int endColumnNumber_ = -1;
    private boolean attachedToPage_;
    private transient Object listeners_lock_ = new Object();
    private Collection<CharacterDataChangeListener> characterDataListeners_;
    private List<CharacterDataChangeListener> characterDataListenersList_;
    private Collection<DomChangeListener> domListeners_;
    private List<DomChangeListener> domListenersList_;
    private Map<String, Object> userData_;

    protected DomNode(SgmlPage page) {
        this.page_ = page;
    }

    public void setStartLocation(int startLineNumber, int startColumnNumber) {
        this.startLineNumber_ = startLineNumber;
        this.startColumnNumber_ = startColumnNumber;
    }

    public void setEndLocation(int endLineNumber, int endColumnNumber) {
        this.endLineNumber_ = endLineNumber;
        this.endColumnNumber_ = endColumnNumber;
    }

    public int getStartLineNumber() {
        return this.startLineNumber_;
    }

    public int getStartColumnNumber() {
        return this.startColumnNumber_;
    }

    public int getEndLineNumber() {
        return this.endLineNumber_;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber_;
    }

    public SgmlPage getPage() {
        return this.page_;
    }

    public HtmlPage getHtmlPageOrNull() {
        if (this.page_ == null || !this.page_.isHtmlPage()) {
            return null;
        }
        return (HtmlPage)this.page_;
    }

    @Override
    public org.w3c.dom.Document getOwnerDocument() {
        return this.getPage();
    }

    public void setScriptableObject(Object scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    @Override
    public DomNode getLastChild() {
        if (this.firstChild_ != null) {
            return this.firstChild_.previousSibling_;
        }
        return null;
    }

    @Override
    public DomNode getParentNode() {
        return this.parent_;
    }

    protected void setParentNode(DomNode parent) {
        this.parent_ = parent;
    }

    public int getIndex() {
        int index = 0;
        DomNode n = this.previousSibling_;
        while (n != null && n.nextSibling_ != null) {
            ++index;
            n = n.previousSibling_;
        }
        return index;
    }

    @Override
    public DomNode getPreviousSibling() {
        if (this.parent_ == null || this == this.parent_.firstChild_) {
            return null;
        }
        return this.previousSibling_;
    }

    @Override
    public DomNode getNextSibling() {
        return this.nextSibling_;
    }

    @Override
    public DomNode getFirstChild() {
        return this.firstChild_;
    }

    public boolean isAncestorOf(DomNode node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public boolean isAncestorOfAny(DomNode ... nodes) {
        for (DomNode node : nodes) {
            if (!this.isAncestorOf(node)) continue;
            return true;
        }
        return false;
    }

    protected void setPreviousSibling(DomNode previous) {
        this.previousSibling_ = previous;
    }

    public void setNextSibling(DomNode next) {
        this.nextSibling_ = next;
    }

    @Override
    public abstract short getNodeType();

    @Override
    public abstract String getNodeName();

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.firstChild_ != null;
    }

    @Override
    public DomNodeList<DomNode> getChildNodes() {
        return new SiblingDomNodeList(this);
    }

    @Override
    public boolean isSupported(String namespace, String featureName) {
        throw new UnsupportedOperationException("DomNode.isSupported is not yet implemented.");
    }

    @Override
    public void normalize() {
        for (DomNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof DomText)) continue;
            boolean removeChildTextNodes = this.hasFeature(BrowserVersionFeatures.DOM_NORMALIZE_REMOVE_CHILDREN);
            StringBuilder dataBuilder = new StringBuilder();
            DomNode toRemove = child;
            DomCharacterData firstText = null;
            while (toRemove instanceof DomText && !(toRemove instanceof DomCDataSection)) {
                DomNode nextChild = toRemove.getNextSibling();
                dataBuilder.append(toRemove.getTextContent());
                if (removeChildTextNodes || firstText != null) {
                    toRemove.remove();
                }
                if (firstText == null) {
                    firstText = (DomText)toRemove;
                }
                toRemove = nextChild;
            }
            if (firstText == null) continue;
            if (removeChildTextNodes) {
                DomText newText = new DomText(this.getPage(), dataBuilder.toString());
                this.insertBefore(newText, toRemove);
                continue;
            }
            firstText.setData(dataBuilder.toString());
        }
    }

    @Override
    public String getBaseURI() {
        return this.getPage().getUrl().toExternalForm();
    }

    @Override
    public short compareDocumentPosition(Node other) {
        Node node;
        int i;
        if (other == this) {
            return 0;
        }
        List<Node> myAncestors = this.getAncestors();
        List<Node> otherAncestors = ((DomNode)other).getAncestors();
        int max = Math.min(myAncestors.size(), otherAncestors.size());
        for (i = 1; i < max && myAncestors.get(i) == otherAncestors.get(i); ++i) {
        }
        if (i != 1 && i == max) {
            if (myAncestors.size() == max) {
                return 20;
            }
            return 10;
        }
        if (max == 1) {
            if (myAncestors.contains(other)) {
                return 8;
            }
            if (otherAncestors.contains(this)) {
                return 20;
            }
            return 33;
        }
        Node myAncestor = myAncestors.get(i);
        Node otherAncestor = otherAncestors.get(i);
        for (node = myAncestor; node != otherAncestor && node != null; node = node.getPreviousSibling()) {
        }
        if (node == null) {
            return 4;
        }
        return 2;
    }

    public List<Node> getAncestors() {
        ArrayList<Node> list = new ArrayList<Node>();
        list.add(this);
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            list.add(0, node);
        }
        return list;
    }

    @Override
    public String getTextContent() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                StringBuilder builder = new StringBuilder();
                for (DomNode child : this.getChildren()) {
                    short childType = child.getNodeType();
                    if (childType == 8 || childType == 7) continue;
                    builder.append(child.getTextContent());
                }
                return builder.toString();
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return this.getNodeValue();
            }
        }
        return null;
    }

    @Override
    public void setTextContent(String textContent) {
        this.removeAllChildren();
        if (textContent != null && !textContent.isEmpty()) {
            this.appendChild(new DomText(this.getPage(), textContent));
        }
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("DomNode.lookupPrefix is not yet implemented.");
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("DomNode.isDefaultNamespace is not yet implemented.");
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("DomNode.lookupNamespaceURI is not yet implemented.");
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException("DomNode.isEqualNode is not yet implemented.");
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("DomNode.getFeature is not yet implemented.");
    }

    @Override
    public Object getUserData(String key) {
        Object value = null;
        if (this.userData_ != null) {
            value = this.userData_.get(key);
        }
        return value;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.userData_ == null) {
            this.userData_ = new HashMap<String, Object>();
        }
        return this.userData_.put(key, data);
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return NamedAttrNodeMapImpl.EMPTY_MAP;
    }

    protected boolean isTrimmedText() {
        return true;
    }

    public boolean isDisplayed() {
        if (!this.mayBeDisplayed()) {
            return false;
        }
        SgmlPage page = this.getPage();
        WebClient webClient = page.getEnclosingWindow().getWebClient();
        if (webClient.getOptions().isCssEnabled() && webClient.isJavaScriptEnabled()) {
            List<Node> ancestors = this.getAncestors();
            ArrayList<CSS2Properties> styles = new ArrayList<CSS2Properties>(ancestors.size());
            for (Node node : ancestors) {
                if (node instanceof HtmlElement && ((HtmlElement)node).isHidden()) {
                    return false;
                }
                Object scriptableObject = ((DomNode)node).getScriptableObject();
                if (!(scriptableObject instanceof HTMLElement)) continue;
                HTMLElement elem = (HTMLElement)scriptableObject;
                CSS2Properties style = elem.getWindow().getComputedStyle(elem, null);
                if (HtmlElement.DisplayStyle.NONE.value().equals(((CSSStyleDeclaration)style).getDisplay())) {
                    return false;
                }
                styles.add(style);
            }
            for (int i = styles.size() - 1; i >= 0; --i) {
                CSSStyleDeclaration style = (CSSStyleDeclaration)styles.get(i);
                String visibility = style.getStyleAttribute(StyleAttributes.Definition.VISIBILITY);
                if (visibility.length() <= 5) continue;
                if ("visible".equals(visibility)) {
                    return true;
                }
                if (!"hidden".equals(visibility) && !"collapse".equals(visibility)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean mayBeDisplayed() {
        return true;
    }

    public String asText() {
        if (this.getPage() instanceof XmlPage) {
            XmlSerializer ser = new XmlSerializer();
            return ser.asText(this);
        }
        HtmlSerializer ser = new HtmlSerializer();
        return ser.asText(this);
    }

    public String getVisibleText() {
        HtmlSerializerVisibleText ser = new HtmlSerializerVisibleText();
        return ser.asText(this);
    }

    public String asXml() {
        Charset charsetName = null;
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage != null) {
            charsetName = htmlPage.getCharset();
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            if (charsetName != null && this instanceof HtmlHtml) {
                printWriter.print("<?xml version=\"1.0\" encoding=\"");
                printWriter.print(charsetName);
                printWriter.print("\"?>\r\n");
            }
            this.printXml("", printWriter);
            String string = stringWriter.toString();
            return string;
        }
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.print(indent);
        printWriter.print(this);
        printWriter.print("\r\n");
        this.printChildrenAsXml(indent, printWriter);
    }

    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        for (DomNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.printXml(indent + "  ", printWriter);
        }
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        DomNode newnode;
        try {
            newnode = (DomNode)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported for node [" + this + "]", e);
        }
        newnode.parent_ = null;
        newnode.nextSibling_ = null;
        newnode.previousSibling_ = null;
        newnode.scriptObject_ = null;
        newnode.firstChild_ = null;
        newnode.attachedToPage_ = false;
        if (deep) {
            DomNode child = this.firstChild_;
            while (child != null) {
                newnode.appendChild(child.cloneNode(true));
                child = child.nextSibling_;
            }
        }
        return newnode;
    }

    public <T> T getScriptableObject() {
        if (this.scriptObject_ == null) {
            SgmlPage page = this.getPage();
            if (this == page) {
                StringBuilder msg = new StringBuilder("No script object associated with the Page.");
                msg.append(" class: '").append(page.getClass().getName()).append('\'');
                try {
                    msg.append(" url: '").append(page.getUrl()).append('\'').append(" content: ").append(page.getWebResponse().getContentAsString());
                }
                catch (Exception e) {
                    msg.append(" no details: '").append(e).append('\'');
                }
                throw new IllegalStateException(msg.toString());
            }
            T o = page.getScriptableObject();
            if (o instanceof SimpleScriptable) {
                this.scriptObject_ = ((SimpleScriptable)o).makeScriptableFor(this);
            }
        }
        return (T)this.scriptObject_;
    }

    @Override
    public DomNode appendChild(Node node) {
        if (node == this) {
            Context.throwAsScriptRuntimeEx((Throwable)new Exception("Can not add not to itself " + this));
            return this;
        }
        DomNode domNode = (DomNode)node;
        if (domNode.isAncestorOf(this)) {
            Context.throwAsScriptRuntimeEx((Throwable)new Exception("Can not add (grand)parent to itself " + this));
        }
        if (domNode instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)domNode;
            for (DomNode child : fragment.getChildren()) {
                this.appendChild(child);
            }
        } else {
            if (domNode.getParentNode() != null) {
                domNode.detach();
            }
            this.basicAppend(domNode);
            this.fireAddition(domNode);
        }
        return domNode;
    }

    private void basicAppend(DomNode node) {
        node.setPage(this.getPage());
        if (this.firstChild_ == null) {
            this.firstChild_ = node;
            this.firstChild_.previousSibling_ = node;
        } else {
            DomNode last = this.getLastChild();
            last.nextSibling_ = node;
            node.previousSibling_ = last;
            node.nextSibling_ = null;
            this.firstChild_.previousSibling_ = node;
        }
        node.parent_ = this;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        if (newChild instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)newChild;
            for (DomNode child : fragment.getChildren()) {
                this.insertBefore(child, refChild);
            }
        } else if (refChild == null) {
            this.appendChild(newChild);
        } else {
            if (refChild.getParentNode() != this) {
                throw new DOMException(8, "Reference node is not a child of this node.");
            }
            ((DomNode)refChild).insertBefore((DomNode)newChild);
        }
        return newChild;
    }

    public void insertBefore(DomNode newNode) {
        if (this.previousSibling_ == null) {
            throw new IllegalStateException("Previous sibling for " + this + " is null.");
        }
        if (newNode == this) {
            return;
        }
        if (newNode.getParentNode() != null) {
            newNode.detach();
        }
        this.basicInsertBefore(newNode);
        this.fireAddition(newNode);
    }

    private void basicInsertBefore(DomNode node) {
        node.setPage(this.page_);
        if (this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = node;
        } else {
            this.previousSibling_.nextSibling_ = node;
        }
        node.previousSibling_ = this.previousSibling_;
        node.nextSibling_ = this;
        this.previousSibling_ = node;
        node.parent_ = this.parent_;
    }

    private void fireAddition(DomNode domNode) {
        boolean wasAlreadyAttached = domNode.isAttachedToPage();
        domNode.attachedToPage_ = this.isAttachedToPage();
        if (this.isAttachedToPage()) {
            SgmlPage page = this.getPage();
            if (null != page && page.isHtmlPage()) {
                ((HtmlPage)page).notifyNodeAdded(domNode);
            }
            if (!domNode.isBodyParsed() && !wasAlreadyAttached) {
                for (DomNode child : domNode.getDescendants()) {
                    child.attachedToPage_ = true;
                    child.onAllChildrenAddedToPage(true);
                }
                domNode.onAllChildrenAddedToPage(true);
            }
        }
        if (this instanceof DomDocumentFragment) {
            this.onAddedToDocumentFragment();
        }
        this.fireNodeAdded(new DomChangeEvent(this, domNode));
    }

    private boolean isBodyParsed() {
        return this.getStartLineNumber() != -1 && this.getEndLineNumber() == -1;
    }

    private void setPage(SgmlPage newPage) {
        if (this.page_ == newPage) {
            return;
        }
        this.page_ = newPage;
        for (DomNode node : this.getChildren()) {
            node.setPage(newPage);
        }
    }

    @Override
    public Node removeChild(Node child) {
        if (child.getParentNode() != this) {
            throw new DOMException(8, "Node is not a child of this node.");
        }
        ((DomNode)child).remove();
        return child;
    }

    public void removeAllChildren() {
        while (this.getFirstChild() != null) {
            this.getFirstChild().remove();
        }
    }

    public void remove() {
        this.detach();
    }

    protected void detach() {
        DomNode exParent = this.parent_;
        this.basicRemove();
        this.fireRemoval(exParent);
    }

    protected void basicRemove() {
        if (this.parent_ != null && this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = this.nextSibling_;
        } else if (this.previousSibling_ != null && this.previousSibling_.nextSibling_ == this) {
            this.previousSibling_.nextSibling_ = this.nextSibling_;
        }
        if (this.nextSibling_ != null && this.nextSibling_.previousSibling_ == this) {
            this.nextSibling_.previousSibling_ = this.previousSibling_;
        }
        if (this.parent_ != null && this == this.parent_.getLastChild()) {
            this.parent_.firstChild_.previousSibling_ = this.previousSibling_;
        }
        this.nextSibling_ = null;
        this.previousSibling_ = null;
        this.parent_ = null;
        this.attachedToPage_ = false;
        for (DomNode descendant : this.getDescendants()) {
            descendant.attachedToPage_ = false;
        }
    }

    private void fireRemoval(DomNode exParent) {
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage != null) {
            this.parent_ = exParent;
            htmlPage.notifyNodeRemoved(this);
            this.parent_ = null;
        }
        if (exParent != null) {
            DomChangeEvent event = new DomChangeEvent(exParent, this);
            this.fireNodeDeleted(event);
            exParent.fireNodeDeleted(event);
        }
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        if (oldChild.getParentNode() != this) {
            throw new DOMException(8, "Node is not a child of this node.");
        }
        ((DomNode)oldChild).replace((DomNode)newChild);
        return oldChild;
    }

    public void replace(DomNode newNode) {
        if (newNode != this) {
            DomNode exParent = this.parent_;
            DomNode exNextSibling = this.nextSibling_;
            this.remove();
            exParent.insertBefore(newNode, exNextSibling);
        }
    }

    public void quietlyRemoveAndMoveChildrenTo(DomNode destination) {
        if (destination.getPage() != this.getPage()) {
            throw new RuntimeException("Cannot perform quiet move on nodes from different pages.");
        }
        for (DomNode child : this.getChildren()) {
            child.basicRemove();
            destination.basicAppend(child);
        }
        this.basicRemove();
    }

    protected void checkChildHierarchy(Node newChild) throws DOMException {
        for (Node parentNode = this; parentNode != null; parentNode = parentNode.getParentNode()) {
            if (parentNode != newChild) continue;
            throw new DOMException(3, "Child node is already a parent.");
        }
        org.w3c.dom.Document thisDocument = this.getOwnerDocument();
        org.w3c.dom.Document childDocument = newChild.getOwnerDocument();
        if (childDocument != thisDocument && childDocument != null) {
            throw new DOMException(4, "Child node " + newChild.getNodeName() + " is not in the same Document as this " + this.getNodeName() + ".");
        }
    }

    protected void onAddedToPage() {
        if (this.firstChild_ != null) {
            for (DomNode child : this.getChildren()) {
                child.onAddedToPage();
            }
        }
    }

    public void onAllChildrenAddedToPage(boolean postponed) {
    }

    protected void onAddedToDocumentFragment() {
        if (this.firstChild_ != null) {
            for (DomNode child : this.getChildren()) {
                child.onAddedToDocumentFragment();
            }
        }
    }

    public final Iterable<DomNode> getChildren() {
        return () -> new ChildIterator();
    }

    public final Iterable<DomNode> getDescendants() {
        return () -> new DescendantElementsIterator<DomNode>(DomNode.class);
    }

    public final Iterable<HtmlElement> getHtmlElementDescendants() {
        return () -> new DescendantElementsIterator<HtmlElement>(HtmlElement.class);
    }

    public final Iterable<DomElement> getDomElementDescendants() {
        return () -> new DescendantElementsIterator<DomElement>(DomElement.class);
    }

    public String getReadyState() {
        return this.readyState_;
    }

    public void setReadyState(String state) {
        this.readyState_ = state;
    }

    private static Map<String, String> parseSelectionNamespaces(String selectionNS) {
        String[] toks;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String tok : toks = selectionNS.split("\\s")) {
            if (tok.startsWith("xmlns=")) {
                result.put("", tok.substring(7, tok.length() - 7));
                continue;
            }
            if (!tok.startsWith("xmlns:")) continue;
            String[] prefix = tok.substring(6).split("=");
            result.put(prefix[0], prefix[1].substring(1, prefix[1].length() - 1));
        }
        return result.isEmpty() ? null : result;
    }

    public <T> List<T> getByXPath(String xpathExpr) {
        Map<String, String> namespaces;
        Object selectionNS;
        ScriptableObject scriptable;
        org.w3c.dom.Document doc;
        PrefixResolver prefixResolver = null;
        if (this.hasFeature(BrowserVersionFeatures.XPATH_SELECTION_NAMESPACES) && (doc = this.getOwnerDocument()) instanceof XmlPage && ScriptableObject.hasProperty((Scriptable)(scriptable = (ScriptableObject)((XmlPage)doc).getScriptableObject()), (String)"getProperty") && (selectionNS = ScriptableObject.callMethod((Scriptable)scriptable, (String)"getProperty", (Object[])new Object[]{"SelectionNamespaces"})) != null && !selectionNS.toString().isEmpty() && (namespaces = DomNode.parseSelectionNamespaces(selectionNS.toString())) != null) {
            prefixResolver = new PrefixResolver(){

                public String getBaseIdentifier() {
                    return (String)namespaces.get("");
                }

                public String getNamespaceForPrefix(String prefix) {
                    return (String)namespaces.get(prefix);
                }

                public String getNamespaceForPrefix(String prefix, Node node) {
                    throw new UnsupportedOperationException();
                }

                public boolean handlesNullPrefixes() {
                    return false;
                }
            };
        }
        return XPathHelper.getByXPath(this, xpathExpr, prefixResolver);
    }

    public List<?> getByXPath(String xpathExpr, PrefixResolver resolver) {
        return XPathHelper.getByXPath(this, xpathExpr, resolver);
    }

    public <X> X getFirstByXPath(String xpathExpr) {
        return this.getFirstByXPath(xpathExpr, null);
    }

    public <X> X getFirstByXPath(String xpathExpr, PrefixResolver resolver) {
        List<?> results = this.getByXPath(xpathExpr, resolver);
        if (results.isEmpty()) {
            return null;
        }
        return (X)results.get(0);
    }

    public String getCanonicalXPath() {
        throw new RuntimeException("Method getCanonicalXPath() not implemented for nodes of type " + this.getNodeType());
    }

    protected void notifyIncorrectness(String message) {
        WebClient client = this.getPage().getEnclosingWindow().getWebClient();
        IncorrectnessListener incorrectnessListener = client.getIncorrectnessListener();
        incorrectnessListener.notify(message, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomChangeListener(DomChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.listeners_lock_;
        synchronized (object) {
            if (this.domListeners_ == null) {
                this.domListeners_ = new LinkedHashSet<DomChangeListener>();
            }
            this.domListeners_.add(listener);
            this.domListenersList_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomChangeListener(DomChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.listeners_lock_;
        synchronized (object) {
            if (this.domListeners_ != null) {
                this.domListeners_.remove(listener);
                this.domListenersList_ = null;
            }
        }
    }

    protected void fireNodeAdded(DomChangeEvent event) {
        List<DomChangeListener> listeners = this.safeGetDomListeners();
        if (listeners != null) {
            for (DomChangeListener listener : listeners) {
                listener.nodeAdded(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireNodeAdded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCharacterDataChangeListener(CharacterDataChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.listeners_lock_;
        synchronized (object) {
            if (this.characterDataListeners_ == null) {
                this.characterDataListeners_ = new LinkedHashSet<CharacterDataChangeListener>();
            }
            this.characterDataListeners_.add(listener);
            this.characterDataListenersList_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCharacterDataChangeListener(CharacterDataChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.listeners_lock_;
        synchronized (object) {
            if (this.characterDataListeners_ != null) {
                this.characterDataListeners_.remove(listener);
                this.characterDataListenersList_ = null;
            }
        }
    }

    protected void fireCharacterDataChanged(CharacterDataChangeEvent event) {
        List<CharacterDataChangeListener> listeners = this.safeGetCharacterDataListeners();
        if (listeners != null) {
            for (CharacterDataChangeListener listener : listeners) {
                listener.characterDataChanged(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireCharacterDataChanged(event);
        }
    }

    protected void fireNodeDeleted(DomChangeEvent event) {
        List<DomChangeListener> listeners = this.safeGetDomListeners();
        if (listeners != null) {
            for (DomChangeListener listener : listeners) {
                listener.nodeDeleted(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireNodeDeleted(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DomChangeListener> safeGetDomListeners() {
        Object object = this.listeners_lock_;
        synchronized (object) {
            if (this.domListeners_ == null) {
                return null;
            }
            if (this.domListenersList_ == null) {
                this.domListenersList_ = new ArrayList<DomChangeListener>(this.domListeners_);
            }
            return this.domListenersList_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CharacterDataChangeListener> safeGetCharacterDataListeners() {
        Object object = this.listeners_lock_;
        synchronized (object) {
            if (this.characterDataListeners_ == null) {
                return null;
            }
            if (this.characterDataListenersList_ == null) {
                this.characterDataListenersList_ = new ArrayList<CharacterDataChangeListener>(this.characterDataListeners_);
            }
            return this.characterDataListenersList_;
        }
    }

    public DomNodeList<DomNode> querySelectorAll(String selectors) {
        try {
            BrowserVersion browserVersion = this.getPage().getWebClient().getBrowserVersion();
            SelectorList selectorList = this.getSelectorList(selectors, browserVersion);
            ArrayList<DomNode> elements = new ArrayList<DomNode>();
            if (selectorList != null) {
                block2: for (DomElement child : this.getDomElementDescendants()) {
                    for (Selector selector : selectorList) {
                        if (!CSSStyleSheet.selects(browserVersion, selector, child, null, true)) continue;
                        elements.add(child);
                        continue block2;
                    }
                }
            }
            return new StaticDomNodeList(elements);
        }
        catch (IOException e) {
            throw new CSSException("Error parsing CSS selectors from '" + selectors + "': " + e.getMessage());
        }
    }

    protected SelectorList getSelectorList(String selectors, BrowserVersion browserVersion) throws IOException {
        CSSOMParser parser = new CSSOMParser((CSSParser)new CSS3Parser());
        CheckErrorHandler errorHandler = new CheckErrorHandler();
        parser.setErrorHandler((CSSErrorHandler)errorHandler);
        SelectorList selectorList = parser.parseSelectors(selectors);
        if (errorHandler.errorDetected()) {
            throw new CSSException("Invalid selectors: " + selectors);
        }
        if (selectorList != null) {
            Object sobj;
            int documentMode = 9;
            if (browserVersion.hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && (sobj = this.getPage().getScriptableObject()) instanceof HTMLDocument) {
                documentMode = ((HTMLDocument)sobj).getDocumentMode();
            }
            CSSStyleSheet.validateSelectors(selectorList, documentMode, this);
        }
        return selectorList;
    }

    public <N extends DomNode> N querySelector(String selectors) {
        DomNodeList<DomNode> list = this.querySelectorAll(selectors);
        if (!list.isEmpty()) {
            return (N)((DomNode)list.get(0));
        }
        return null;
    }

    public boolean isAttachedToPage() {
        return this.attachedToPage_;
    }

    public void processImportNode(Document doc) {
        this.page_ = (SgmlPage)doc.getDomNodeOrDie();
    }

    public boolean hasFeature(BrowserVersionFeatures feature) {
        return this.getPage().getWebClient().getBrowserVersion().hasFeature(feature);
    }

    public boolean handles(Event event) {
        return true;
    }

    public DomElement getPreviousElementSibling() {
        DomNode node;
        for (node = this.getPreviousSibling(); node != null && !(node instanceof DomElement); node = node.getPreviousSibling()) {
        }
        return (DomElement)node;
    }

    public DomElement getNextElementSibling() {
        DomNode node;
        for (node = this.getNextSibling(); node != null && !(node instanceof DomElement); node = node.getNextSibling()) {
        }
        return (DomElement)node;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners_lock_ = new Object();
    }

    private static final class CheckErrorHandler
    implements CSSErrorHandler {
        private boolean errorDetected_ = false;

        protected CheckErrorHandler() {
        }

        private boolean errorDetected() {
            return this.errorDetected_;
        }

        public void warning(CSSParseException exception) throws CSSException {
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            this.errorDetected_ = true;
        }

        public void error(CSSParseException exception) throws CSSException {
            this.errorDetected_ = true;
        }
    }

    protected class DescendantElementsIterator<T extends DomNode>
    implements Iterator<T> {
        private DomNode currentNode_;
        private DomNode nextNode_;
        private final Class<T> type_;

        public DescendantElementsIterator(Class<T> type) {
            this.type_ = type;
            this.nextNode_ = this.getFirstChildElement(DomNode.this);
        }

        @Override
        public boolean hasNext() {
            return this.nextNode_ != null;
        }

        @Override
        public T next() {
            return this.nextNode();
        }

        @Override
        public void remove() {
            if (this.currentNode_ == null) {
                throw new IllegalStateException("Unable to remove current node, because there is no current node.");
            }
            DomNode current = this.currentNode_;
            while (this.nextNode_ != null && current.isAncestorOf(this.nextNode_)) {
                this.next();
            }
            current.remove();
        }

        public T nextNode() {
            this.currentNode_ = this.nextNode_;
            this.setNextElement();
            return (T)this.currentNode_;
        }

        private void setNextElement() {
            DomNode next = this.getFirstChildElement(this.nextNode_);
            if (next == null) {
                next = this.getNextDomSibling(this.nextNode_);
            }
            if (next == null) {
                next = this.getNextElementUpwards(this.nextNode_);
            }
            this.nextNode_ = next;
        }

        private DomNode getNextElementUpwards(DomNode startingNode) {
            DomNode next;
            if (startingNode == DomNode.this) {
                return null;
            }
            DomNode parent = startingNode.getParentNode();
            if (parent == null || parent == DomNode.this) {
                return null;
            }
            for (next = parent.getNextSibling(); next != null && !this.isAccepted(next); next = next.getNextSibling()) {
            }
            if (next == null) {
                return this.getNextElementUpwards(parent);
            }
            return next;
        }

        private DomNode getFirstChildElement(DomNode parent) {
            DomNode node;
            for (node = parent.getFirstChild(); node != null && !this.isAccepted(node); node = node.getNextSibling()) {
            }
            return node;
        }

        protected boolean isAccepted(DomNode node) {
            return this.type_.isAssignableFrom(node.getClass());
        }

        private DomNode getNextDomSibling(DomNode element) {
            DomNode node;
            for (node = element.getNextSibling(); node != null && !this.isAccepted(node); node = node.getNextSibling()) {
            }
            return node;
        }
    }

    protected class ChildIterator
    implements Iterator<DomNode> {
        private DomNode nextNode_;
        private DomNode currentNode_;

        protected ChildIterator() {
            this.nextNode_ = DomNode.this.firstChild_;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode_ != null;
        }

        @Override
        public DomNode next() {
            if (this.nextNode_ != null) {
                this.currentNode_ = this.nextNode_;
                this.nextNode_ = this.nextNode_.nextSibling_;
                return this.currentNode_;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentNode_ == null) {
                throw new IllegalStateException();
            }
            this.currentNode_.remove();
        }
    }
}

