/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParser;
import com.gargoylesoftware.htmlunit.html.parser.neko.HtmlUnitNekoHtmlParser;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultPageCreator
implements PageCreator,
Serializable {
    private static final byte[] markerUTF8_ = new byte[]{-17, -69, -65};
    private static final byte[] markerUTF16BE_ = new byte[]{-2, -1};
    private static final byte[] markerUTF16LE_ = new byte[]{-1, -2};
    private static final HTMLParser htmlParser_ = new HtmlUnitNekoHtmlParser();

    public static PageType determinePageType(String contentType) {
        if (null == contentType) {
            return PageType.UNKNOWN;
        }
        switch (contentType) {
            case "text/html": 
            case "image/svg+xml": {
                return PageType.HTML;
            }
            case "text/javascript": 
            case "application/x-javascript": 
            case "application/javascript": {
                return PageType.JAVASCRIPT;
            }
            case "text/xml": 
            case "application/xml": 
            case "text/vnd.wap.wml": {
                return PageType.XML;
            }
        }
        if (contentType.endsWith("+xml")) {
            return PageType.XML;
        }
        if (contentType.startsWith("text/")) {
            return PageType.TEXT;
        }
        return PageType.UNKNOWN;
    }

    @Override
    public Page createPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        String contentType = this.determineContentType(webResponse);
        PageType pageType = DefaultPageCreator.determinePageType(contentType);
        switch (pageType) {
            case HTML: {
                return this.createHtmlPage(webResponse, webWindow);
            }
            case JAVASCRIPT: {
                return this.createHtmlPage(webResponse, webWindow);
            }
            case XML: {
                SgmlPage sgmlPage = this.createXmlPage(webResponse, webWindow);
                DomElement doc = sgmlPage.getDocumentElement();
                if (doc != null && "http://www.w3.org/1999/xhtml".equals(doc.getNamespaceURI())) {
                    return this.createXHtmlPage(webResponse, webWindow);
                }
                return sgmlPage;
            }
            case TEXT: {
                return this.createTextPage(webResponse, webWindow);
            }
        }
        return this.createUnexpectedPage(webResponse, webWindow);
    }

    private String determineContentType(WebResponse webResponse) throws IOException {
        String contentType = webResponse.getContentType();
        if (!StringUtils.isEmpty((CharSequence)contentType)) {
            return contentType.toLowerCase(Locale.ROOT);
        }
        try (InputStream contentAsStream = webResponse.getContentAsStream();){
            byte[] bytes = DefaultPageCreator.read(contentAsStream, 500);
            if (bytes.length == 0) {
                String string = "text/plain";
                return string;
            }
            String asAsciiString = new String(bytes, "ASCII").toUpperCase(Locale.ROOT);
            if (asAsciiString.contains("<HTML")) {
                String string = "text/html";
                return string;
            }
            if (DefaultPageCreator.startsWith(bytes, markerUTF8_) || DefaultPageCreator.startsWith(bytes, markerUTF16BE_) || DefaultPageCreator.startsWith(bytes, markerUTF16LE_)) {
                String string = "text/plain";
                return string;
            }
            if (asAsciiString.trim().startsWith("<SCRIPT>")) {
                String string = "application/javascript";
                return string;
            }
            if (DefaultPageCreator.isBinary(bytes)) {
                String string = "application/octet-stream";
                return string;
            }
        }
        return "text/plain";
    }

    @Override
    public HTMLParser getHtmlParser() {
        return htmlParser_;
    }

    private static boolean isBinary(byte[] bytes) {
        for (byte b : bytes) {
            if (b >= 8 && b != 11 && (b < 14 || b > 26) && (b < 28 || b > 31)) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(byte[] bytes, byte[] lookFor) {
        if (bytes.length < lookFor.length) {
            return false;
        }
        for (int i = 0; i < lookFor.length; ++i) {
            if (bytes[i] == lookFor[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] read(InputStream stream, int maxNb) throws IOException {
        byte[] buffer = new byte[maxNb];
        int nbRead = stream.read(buffer);
        if (nbRead == buffer.length) {
            return buffer;
        }
        return ArrayUtils.subarray((byte[])buffer, (int)0, (int)nbRead);
    }

    protected HtmlPage createHtmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        HtmlPage page = new HtmlPage(webResponse, webWindow);
        webWindow.setEnclosedPage(page);
        htmlParser_.parse(webResponse, page, false);
        return page;
    }

    protected XHtmlPage createXHtmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XHtmlPage page = new XHtmlPage(webResponse, webWindow);
        webWindow.setEnclosedPage(page);
        htmlParser_.parse(webResponse, page, true);
        return page;
    }

    protected TextPage createTextPage(WebResponse webResponse, WebWindow webWindow) {
        TextPage newPage = new TextPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected UnexpectedPage createUnexpectedPage(WebResponse webResponse, WebWindow webWindow) {
        UnexpectedPage newPage = new UnexpectedPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected SgmlPage createXmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XmlPage page = new XmlPage(webResponse, webWindow);
        webWindow.setEnclosedPage(page);
        return page;
    }

    public static enum PageType {
        HTML,
        JAVASCRIPT,
        XML,
        TEXT,
        UNKNOWN;

    }
}

