/*
 * Copyright (c) 2002-2017 Gargoyle Software Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.gargoylesoftware.htmlunit.javascript.host.media;

import static com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser.CHROME;
import static com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser.EDGE;
import static com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser.FF;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;

/**
 * A JavaScript object for {@code MediaError}.
 *
 * @author Ahmed Ashour
 */
@JsxClass
public class MediaError extends SimpleScriptable {

    /** Aborted Error. */
    @JsxConstant
    public static final int MEDIA_ERR_ABORTED = 1;

    /** Network Error. */
    @JsxConstant
    public static final int MEDIA_ERR_NETWORK = 2;

    /** Decode Error. */
    @JsxConstant
    public static final int MEDIA_ERR_DECODE = 3;

    /** Source Not Supported Error. */
    @JsxConstant
    public static final int MEDIA_ERR_SRC_NOT_SUPPORTED = 4;

    /**
     * Creates an instance.
     */
    @JsxConstructor({CHROME, FF, EDGE})
    public MediaError() {
    }

}
