/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtils {
    public static String capitalizePropertyName(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Map<String, Method> getSetters(Class<?> clazz) {
        Method[] methods;
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || !methodName.startsWith("set") || methodName.length() <= 3 || method.getReturnType() != Void.TYPE) continue;
            String propertyName = methodName.substring(3, 4).toLowerCase();
            if (methodName.length() > 4) {
                propertyName = propertyName + methodName.substring(4);
            }
            setters.put(propertyName, method);
        }
        return setters;
    }

    public static Map<String, Method> getGetters(Class<?> clazz) {
        Method[] methods;
        HashMap<String, Method> getters = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String propertyName;
            String methodName = method.getName();
            if (method.getParameterTypes().length != 0) continue;
            if (methodName.startsWith("get") && methodName.length() > 3) {
                propertyName = methodName.substring(3, 4).toLowerCase();
                if (methodName.length() > 4) {
                    propertyName = propertyName + methodName.substring(4);
                }
                getters.put(propertyName, method);
                continue;
            }
            if (!methodName.startsWith("is") || methodName.length() <= 2 || !Boolean.TYPE.equals(method.getReturnType())) continue;
            propertyName = methodName.substring(2, 3).toLowerCase();
            if (methodName.length() > 3) {
                propertyName = propertyName + methodName.substring(3);
            }
            getters.put(propertyName, method);
        }
        return getters;
    }

    public static Method getGetterPropertyMethod(Class<?> type, String propertyName) {
        String sourceMethodName = "get" + BeanUtils.capitalizePropertyName(propertyName);
        Method sourceMethod = BeanUtils.getMethod(type, sourceMethodName, new Class[0]);
        if (sourceMethod == null && (sourceMethod = BeanUtils.getMethod(type, sourceMethodName = "is" + BeanUtils.capitalizePropertyName(propertyName), new Class[0])) != null && sourceMethod.getReturnType() != Boolean.TYPE) {
            sourceMethod = null;
        }
        return sourceMethod;
    }

    public static Method getSetterPropertyMethod(Class<?> type, String propertyName) {
        String sourceMethodName = "set" + BeanUtils.capitalizePropertyName(propertyName);
        Method sourceMethod = BeanUtils.getMethod(type, sourceMethodName, new Class[0]);
        return sourceMethod;
    }
}

