/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.type;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType actualType = (ParameterizedType)type;
            return TypeUtils.getRawType(actualType.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Object rawArrayType = Array.newInstance(TypeUtils.getRawType(genericArrayType.getGenericComponentType()), 0);
            return rawArrayType.getClass();
        }
        if (type instanceof WildcardType) {
            WildcardType castedType = (WildcardType)type;
            return TypeUtils.getRawType(castedType.getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("Type '" + type + "' is not a Class, " + "ParameterizedType, or GenericArrayType. Can't extract class.");
    }

    public static boolean isAssignableFrom(TypeReference<?> from, TypeReference<?> to) {
        if (from == null) {
            return false;
        }
        if (to.equals(from)) {
            return true;
        }
        if (to.getType() instanceof Class) {
            return to.getRawType().isAssignableFrom(from.getRawType());
        }
        if (to.getType() instanceof ParameterizedType) {
            return TypeUtils.isAssignableFrom(from.getType(), (ParameterizedType)to.getType(), new HashMap<String, Type>());
        }
        if (to.getType() instanceof GenericArrayType) {
            return to.getRawType().isAssignableFrom(from.getRawType()) && TypeUtils.isAssignableFrom(from.getType(), (GenericArrayType)to.getType());
        }
        throw new AssertionError((Object)("Unexpected Type : " + to));
    }

    private static boolean isAssignableFrom(Type from, ParameterizedType to, Map<String, Type> typeVarMap) {
        if (from == null) {
            return false;
        }
        if (to.equals(from)) {
            return true;
        }
        Class<?> clazz = TypeUtils.getRawType(from);
        ParameterizedType ptype = null;
        if (from instanceof ParameterizedType) {
            ptype = (ParameterizedType)from;
        }
        if (ptype != null) {
            Type[] tArgs = ptype.getActualTypeArguments();
            TypeVariable<Class<?>>[] tParams = clazz.getTypeParameters();
            for (int i = 0; i < tArgs.length; ++i) {
                Type arg = tArgs[i];
                TypeVariable<Class<?>> var = tParams[i];
                while (arg instanceof TypeVariable) {
                    TypeVariable v = (TypeVariable)arg;
                    arg = typeVarMap.get(v.getName());
                }
                typeVarMap.put(var.getName(), arg);
            }
            if (TypeUtils.typeEquals(ptype, to, typeVarMap)) {
                return true;
            }
        }
        for (Type itype : clazz.getGenericInterfaces()) {
            if (!TypeUtils.isAssignableFrom(itype, to, new HashMap<String, Type>(typeVarMap))) continue;
            return true;
        }
        Type sType = clazz.getGenericSuperclass();
        return TypeUtils.isAssignableFrom(sType, to, new HashMap<String, Type>(typeVarMap));
    }

    private static boolean typeEquals(ParameterizedType from, ParameterizedType to, Map<String, Type> typeVarMap) {
        if (from.getRawType().equals(to.getRawType())) {
            Type[] fromArgs = from.getActualTypeArguments();
            Type[] toArgs = to.getActualTypeArguments();
            for (int i = 0; i < fromArgs.length; ++i) {
                if (TypeUtils.matches(fromArgs[i], toArgs[i], typeVarMap)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean matches(Type from, Type to, Map<String, Type> typeMap) {
        if (to.equals(from)) {
            return true;
        }
        if (from instanceof TypeVariable) {
            return to.equals(typeMap.get(((TypeVariable)from).getName()));
        }
        return false;
    }

    private static boolean isAssignableFrom(Type from, GenericArrayType to) {
        Type toGenericComponentType = to.getGenericComponentType();
        if (toGenericComponentType instanceof ParameterizedType) {
            Type t = from;
            if (from instanceof GenericArrayType) {
                t = ((GenericArrayType)from).getGenericComponentType();
            } else if (from instanceof Class) {
                Class<?> classType = (Class<?>)from;
                while (classType.isArray()) {
                    classType = classType.getComponentType();
                }
                t = classType;
            }
            return TypeUtils.isAssignableFrom(t, (ParameterizedType)toGenericComponentType, new HashMap<String, Type>());
        }
        return true;
    }
}

