/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.entropysoft.transmorph.signature.TypeSignature;
import net.entropysoft.transmorph.signature.TypeSignatureFactory;
import net.entropysoft.transmorph.signature.formatter.JavaSyntaxTypeSignatureFormatter;
import net.entropysoft.transmorph.type.ParameterizedTypeImpl;
import net.entropysoft.transmorph.type.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeReference<T>
implements Comparable<TypeReference<T>> {
    private final Type type;
    private final Class<? super T> rawType;
    private volatile TypeSignature typeSignature;

    protected TypeReference() {
        this.type = TypeReference.getSuperclassTypeParameter(this.getClass());
        this.rawType = TypeUtils.getRawType(this.type);
    }

    private TypeReference(Type type) {
        this.type = type;
        this.rawType = TypeUtils.getRawType(type);
    }

    public static <T> TypeReference<T> get(Class<T> type) {
        return new SimpleTypeReference(type);
    }

    public static TypeReference<?> get(Type type) {
        return new SimpleTypeReference(type);
    }

    public static TypeReference<?> get(Class<?> clazz, Class<?>[] typeArgs) {
        return TypeReference.get(new ParameterizedTypeImpl(clazz, typeArgs, null));
    }

    public Type getType() {
        return this.type;
    }

    public Class<? super T> getRawType() {
        return this.rawType;
    }

    public boolean isArray() {
        if (this.type instanceof Class) {
            return ((Class)this.type).isArray();
        }
        return this.type instanceof GenericArrayType;
    }

    public boolean isRawTypeInstance(Object object) {
        return this.rawType.isInstance(object);
    }

    public boolean isType(Type type) {
        return this.type == type;
    }

    public boolean hasRawType(Class<?> type) {
        return this.rawType == type;
    }

    public boolean isPrimitive() {
        return this.type == Byte.TYPE || this.type == Short.TYPE || this.type == Integer.TYPE || this.type == Long.TYPE || this.type == Float.TYPE || this.type == Double.TYPE || this.type == Character.TYPE || this.type == Boolean.TYPE;
    }

    public boolean isRawTypeSubOf(Class<?> superClass) {
        return superClass.isAssignableFrom(this.rawType);
    }

    public boolean isAssignableFrom(TypeReference<?> typeReference) {
        return TypeUtils.isAssignableFrom(this, typeReference);
    }

    public TypeSignature getTypeSignature() {
        if (this.typeSignature == null) {
            this.typeSignature = TypeSignatureFactory.getTypeSignature(this.type);
        }
        return this.typeSignature;
    }

    public boolean isNumber() {
        if (this.type == Byte.TYPE || this.type == Short.TYPE || this.type == Integer.TYPE || this.type == Long.TYPE || this.type == Float.TYPE || this.type == Double.TYPE) {
            return true;
        }
        return this.isRawTypeSubOf(Number.class);
    }

    public String toHumanString() {
        JavaSyntaxTypeSignatureFormatter typeSignatureFormatter = new JavaSyntaxTypeSignatureFormatter();
        return typeSignatureFormatter.format(this.getTypeSignature());
    }

    public TypeReference<?>[] getTypeArguments() {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            TypeReference[] typeReferences = new TypeReference[typeArguments.length];
            for (int i = 0; i < typeArguments.length; ++i) {
                typeReferences[i] = TypeReference.get(typeArguments[i]);
            }
            return typeReferences;
        }
        return new TypeReference[0];
    }

    public TypeReference<?> getArrayElementType() {
        if (!this.isArray()) {
            return null;
        }
        TypeReference<?> componentType = this.getArrayComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getArrayComponentType();
        }
        return componentType;
    }

    public TypeReference<?> getArrayComponentType() {
        if (!this.isArray()) {
            return null;
        }
        if (this.type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)this.type;
            return TypeReference.get(genericArrayType.getGenericComponentType());
        }
        return TypeReference.get(this.rawType.getComponentType());
    }

    public int getArrayNumDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        int numDim = 1;
        TypeReference<?> componentType = this.getArrayComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getArrayComponentType();
            ++numDim;
        }
        return numDim;
    }

    @Override
    public int compareTo(TypeReference<T> o) {
        return this.toString().compareTo(o.toString());
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeReference)) {
            return false;
        }
        TypeReference t = (TypeReference)o;
        return this.type.equals(t.type);
    }

    public String toString() {
        return this.type.toString();
    }

    public static Type getSuperclassTypeParameter(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleTypeReference<T>
    extends TypeReference<T> {
        public SimpleTypeReference(Type type) {
            super(type);
        }
    }
}

