/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> rawType;
    private final Type[] actualTypeArguments;
    private final Type owner;

    public ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments, Type owner) {
        this.rawType = rawType;
        this.actualTypeArguments = actualTypeArguments;
        this.owner = owner;
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType that = (ParameterizedType)o;
        if (this == that) {
            return true;
        }
        Type thatOwner = that.getOwnerType();
        Type thatRawType = that.getRawType();
        return (this.owner == null ? thatOwner == null : this.owner.equals(thatOwner)) && (this.rawType == null ? thatRawType == null : this.rawType.equals(thatRawType)) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ (this.owner == null ? 0 : this.owner.hashCode()) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.owner != null) {
            if (this.owner instanceof Class) {
                sb.append(((Class)this.owner).getName());
            } else {
                sb.append(this.owner.toString());
            }
            sb.append('.');
            if (this.owner instanceof ParameterizedType) {
                ParameterizedType parameterizedOwnerType = (ParameterizedType)this.owner;
                String simpleName = this.rawType.getName().replace(((Class)parameterizedOwnerType.getRawType()).getName() + "$", "");
                sb.append(simpleName);
            } else {
                sb.append(this.rawType.getName());
            }
        } else {
            sb.append(this.rawType.getName());
        }
        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            sb.append("<");
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                Type type = this.actualTypeArguments[i];
                if (i > 0) {
                    sb.append(", ");
                }
                if (type instanceof Class) {
                    sb.append(((Class)type).getName());
                    continue;
                }
                sb.append(type.toString());
            }
            sb.append(">");
        }
        return sb.toString();
    }
}

