/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature.formatter;

import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.signature.ArrayTypeSignature;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.PrimitiveTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;
import net.entropysoft.transmorph.signature.TypeSignature;
import net.entropysoft.transmorph.signature.formatter.ClassFileTypeSignatureFormatter;
import net.entropysoft.transmorph.signature.formatter.ITypeSignatureFormatter;

public class ClassGetNameSignatureFormatter
implements ITypeSignatureFormatter {
    private static Map<Character, String> primitiveTypesMap = new HashMap<Character, String>();
    private ClassFileTypeSignatureFormatter typeSignatureFormatter = new ClassFileTypeSignatureFormatter(false);

    public String format(TypeSignature typeSignature) {
        if (typeSignature.isPrimitiveType()) {
            return this.format((PrimitiveTypeSignature)typeSignature);
        }
        if (typeSignature.isArrayType()) {
            return this.format((ArrayTypeSignature)typeSignature);
        }
        if (typeSignature.isClassType()) {
            return this.format((ClassTypeSignature)typeSignature);
        }
        if (typeSignature.isTypeVar()) {
            // empty if block
        }
        if (typeSignature.isTypeArgument()) {
            return this.format((TypeArgSignature)typeSignature);
        }
        return null;
    }

    private String format(PrimitiveTypeSignature typeSignature) {
        return primitiveTypesMap.get(Character.valueOf(typeSignature.getPrimitiveTypeChar()));
    }

    private String format(ArrayTypeSignature typeSignature) {
        FullTypeSignature typeErasureSignature = typeSignature.getTypeErasureSignature();
        return this.typeSignatureFormatter.format(typeErasureSignature);
    }

    private String format(ClassTypeSignature typeSignature) {
        return typeSignature.getClassName();
    }

    private String format(TypeArgSignature typeSignature) {
        return this.format(typeSignature.getTypeErasureSignature());
    }

    static {
        primitiveTypesMap.put(Character.valueOf('Z'), Boolean.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('B'), Byte.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('C'), Character.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('D'), Double.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('F'), Float.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('I'), Integer.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('J'), Long.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('S'), Short.TYPE.getName());
    }
}

